import { LogoProps } from './types';
export type { LogoProps };
/**
 * These are the default parameters for LogoProps if the user does not specify values.
 */
export declare const defaultLogoParams: Partial<LogoProps>;
/**
 * The props for the <Wrapper /> that takes the svg and turns it into a component.
 */
export type WrapperProps = LogoProps & {
    svg: string;
};
export declare const sizes: {
    readonly xsmall: 16;
    readonly small: 24;
    readonly medium: 32;
    readonly large: 40;
    readonly xlarge: 48;
};
/**
 * In order to pass linting rules, these props were renamed to be more descriptive i.e. props renamed to LogoProps and
 * defaultParams to defaultLogoParams. However, this is a breaking change as it is a file with public entry points. The code
 * below is here to keep Logo backwards compatible.
 * See the ticket here: https://product-fabric.atlassian.net/browse/DSP-4086.
 *
 * Note that some consumers are accessing this using like so: import { Props } from '@atlaskit/logo/constants', this should
 * still work despite `LogoProps` being in a different types.tsx file.
 *
 */
/**
 * @deprecated {@link https://hello.atlassian.net/browse/ENGHEALTH-175 Internal documentation for deprecation (no external access)} This has been renamed, please import `LogoProps` instead.
 */
export type Props = LogoProps;
/**
 * @deprecated {@link https://hello.atlassian.net/browse/ENGHEALTH-176 Internal documentation for deprecation (no external access)} This has been renamed, please import `defaultLogoParams` instead.
 */
export declare const DefaultProps: Partial<LogoProps>;
