"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("@emotion/react");
var _colors = require("@atlaskit/theme/colors");
/** @jsx jsx */

/**
 * These keyframes are mirrored in:
 * packages/design-system/theme/src/constants.tsx
 *
 * Please update both.
 */
var shimmerKeyframes = (0, _react.keyframes)({
  from: {
    backgroundColor: "var(--ds-skeleton, ".concat(_colors.N20A, ")")
  },
  to: {
    backgroundColor: "var(--ds-skeleton-subtle, ".concat(_colors.N30A, ")")
  }
});

/**
 * These styles are mirrored in:
 * packages/design-system/theme/src/constants.tsx
 *
 * Please update both.
 */
var shimmerStyles = (0, _react.css)({
  '::before, ::after': {
    animationDirection: 'alternate',
    animationDuration: '1.5s',
    animationIterationCount: 'infinite',
    animationName: "".concat(shimmerKeyframes),
    animationTimingFunction: 'linear',
    backgroundColor: "var(--ds-skeleton, ".concat(_colors.N20A, ")")
  }
});

/**
 * __Skeleton shimmer__
 *
 * A skeleton shimmer is the animation shown on loading skeletons for
 * perceived performance and user satisfaction.
 *
 * This component provides a `className` through render props. This value will
 * have type:
 * + `string`, when `isShimmering={true}`.
 * + `undefined`, when `isShimmering={false}`.
 *
 * @internal
 */
var SkeletonShimmer = function SkeletonShimmer(_ref) {
  var children = _ref.children,
    _ref$isShimmering = _ref.isShimmering,
    isShimmering = _ref$isShimmering === void 0 ? false : _ref$isShimmering;
  return (0, _react.jsx)(_react.ClassNames, null, function (_ref2) {
    var css = _ref2.css;
    return children({
      className: isShimmering ? css(shimmerStyles) : undefined
    });
  });
};
var _default = SkeletonShimmer;
exports.default = _default;