"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _deprecationWarning = require("@atlaskit/ds-lib/deprecation-warning");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _menuItemPrimitive = _interopRequireDefault(require("../internal/components/menu-item-primitive"));
var _excluded = ["component", "cssFn", "isDisabled", "isSelected", "onClick", "testId", "children", "description", "iconAfter", "iconBefore", "overrides", "onMouseDown", "shouldTitleWrap", "shouldDescriptionWrap"];
/** @jsx jsx */
var preventEvent = function preventEvent(e) {
  e.preventDefault();
};

// Dirty hack to get generics working with forward ref [1/2]

/**
 * __Custom item__
 *
 * A custom item is used to populate a menu with items that can be any element.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/custom-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var CustomItem = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var Component = _ref.component,
    _ref$cssFn = _ref.cssFn,
    cssFn = _ref$cssFn === void 0 ? _noop.default : _ref$cssFn,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    onClick = _ref.onClick,
    testId = _ref.testId,
    children = _ref.children,
    description = _ref.description,
    iconAfter = _ref.iconAfter,
    iconBefore = _ref.iconBefore,
    overrides = _ref.overrides,
    onMouseDown = _ref.onMouseDown,
    shouldTitleWrap = _ref.shouldTitleWrap,
    shouldDescriptionWrap = _ref.shouldDescriptionWrap,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var onMouseDownHandler = onMouseDown;
  if (!Component) {
    return null;
  }
  (0, _deprecationWarning.propDeprecationWarning)("@atlaskit/menu", 'cssFn', cssFn !== _noop.default, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return (0, _react2.jsx)(_menuItemPrimitive.default, (0, _extends2.default)({}, rest, {
    // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
    overrides: overrides,
    description: description,
    iconAfter: iconAfter,
    title: children,
    iconBefore: iconBefore,
    isSelected: isSelected,
    isDisabled: isDisabled,
    shouldTitleWrap: shouldTitleWrap,
    shouldDescriptionWrap: shouldDescriptionWrap
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    ,
    css: (0, _react2.css)(cssFn({
      isDisabled: isDisabled,
      isSelected: isSelected
    }))
  }), function (_ref2) {
    var children = _ref2.children,
      className = _ref2.className;
    return (0, _react2.jsx)(Component, (0, _extends2.default)({
      "data-testid": testId
    }, rest, {
      className: className,
      ref: ref,
      draggable: false,
      onDragStart: preventEvent,
      onMouseDown: isDisabled ? preventEvent : onMouseDownHandler,
      onClick: isDisabled ? preventEvent : onClick,
      tabIndex: isDisabled ? -1 : undefined,
      "aria-disabled": isDisabled
    }), children);
  });
})
// Dirty hack to get generics working with forward ref [2/2]
);
var _default = CustomItem;
exports.default = _default;