"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _deprecationWarning = require("@atlaskit/ds-lib/deprecation-warning");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _colors = require("@atlaskit/theme/colors");
var _typography = require("@atlaskit/theme/typography");
var _excluded = ["children", "testId", "id", "cssFn"];
/** @jsx jsx */
var itemHeadingContentHeight = _typography.headingSizes.h100.lineHeight;
var itemHeadingFontSize = _typography.headingSizes.h100.size;
var headingStyles = (0, _react2.css)({
  color: "var(--ds-text-subtle, ".concat(_colors.N300, ")"),
  fontSize: itemHeadingFontSize,
  fontWeight: "var(--ds-font-weight-bold, 700)",
  lineHeight: itemHeadingContentHeight / itemHeadingFontSize,
  paddingBlock: "var(--ds-space-0, 0px)",
  paddingInline: "var(--ds-space-200, 16px)",
  textTransform: 'uppercase'
});

/**
 * __Heading item__
 *
 * A heading item is used to describe sibling menu items.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/heading-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var HeadingItem = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var children = _ref.children,
    testId = _ref.testId,
    id = _ref.id,
    _ref$cssFn = _ref.cssFn,
    cssFn = _ref$cssFn === void 0 ? _noop.default : _ref$cssFn,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  (0, _deprecationWarning.propDeprecationWarning)("@atlaskit/menu", 'cssFn', cssFn !== _noop.default, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: [headingStyles,
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    (0, _react2.css)(cssFn(undefined))],
    "data-testid": testId,
    "data-ds--menu--heading-item": true,
    id: id
  }, rest), children);
});
var _default = HeadingItem;
exports.default = _default;