"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("@emotion/react");
var _deprecationWarning = require("@atlaskit/ds-lib/deprecation-warning");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _colors = require("@atlaskit/theme/colors");
var _constants = require("@atlaskit/theme/constants");
var _skeletonShimmer = _interopRequireDefault(require("../internal/components/skeleton-shimmer"));
/** @jsx jsx */

var gridSize = (0, _constants.gridSize)();
var borderRadius = (0, _constants.borderRadius)();
var itemElemSpacing = gridSize * 1.5;
var itemExpectedElemSize = gridSize * 3;
var itemMinHeight = gridSize * 5;
var skeletonItemElemSize = gridSize * 2.5;
var itemElemSkeletonOffset = (itemExpectedElemSize - skeletonItemElemSize) / 2;
var skeletonTextBorderRadius = 100;
var skeletonContentHeight = 9;
var skeletonColor = "var(--ds-skeleton, ".concat(_colors.N20A, ")");
var skeletonStyles = (0, _react.css)({
  display: 'flex',
  minHeight: itemMinHeight,
  padding: "0 ".concat("var(--ds-space-250, 20px)"),
  alignItems: 'center',
  pointerEvents: 'none',
  '::after': {
    height: skeletonContentHeight,
    // This is a little bespoke but we need to push everything down 1px
    // because the skeleton content should align to the bottom of the text.
    // Confirm VR test failures before accepting a change.
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    marginTop: 1,
    backgroundColor: skeletonColor,
    borderRadius: skeletonTextBorderRadius,
    content: '""'
  }
});
var defaultWidthStyles = (0, _react.css)({
  ':nth-of-type(1n)::after': {
    flexBasis: '70%'
  },
  ':nth-of-type(2n)::after': {
    flexBasis: '50%'
  },
  ':nth-of-type(3n)::after': {
    flexBasis: '60%'
  },
  ':nth-of-type(4n)::after': {
    flexBasis: '90%'
  },
  ':nth-of-type(5n)::after': {
    flexBasis: '35%'
  },
  ':nth-of-type(6n)::after': {
    flexBasis: '77%'
  }
});
var customWidthStyles = (0, _react.css)({
  '::after': {
    flexBasis: 'var(--width)'
  }
});
var beforeElementStyles = (0, _react.css)({
  '::before': {
    width: skeletonItemElemSize,
    height: skeletonItemElemSize,
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    marginRight: itemElemSpacing + itemElemSkeletonOffset,
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    marginLeft: itemElemSkeletonOffset,
    flexShrink: 0,
    backgroundColor: skeletonColor,
    content: '""'
  }
});
var avatarStyles = (0, _react.css)({
  '::before': {
    borderRadius: '100%'
  }
});
var iconStyles = (0, _react.css)({
  '::before': {
    borderRadius: borderRadius
  }
});

/**
 * __Skeleton item__
 *
 * A skeleton item is used in place of an item when its contents it not ready.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/skeleton-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var SkeletonItem = function SkeletonItem(_ref) {
  var hasAvatar = _ref.hasAvatar,
    hasIcon = _ref.hasIcon,
    _ref$isShimmering = _ref.isShimmering,
    isShimmering = _ref$isShimmering === void 0 ? false : _ref$isShimmering,
    testId = _ref.testId,
    width = _ref.width,
    _ref$cssFn = _ref.cssFn,
    cssFn = _ref$cssFn === void 0 ? _noop.default : _ref$cssFn;
  (0, _deprecationWarning.propDeprecationWarning)("@atlaskit/menu", 'cssFn', cssFn !== _noop.default, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return (0, _react.jsx)(_skeletonShimmer.default, {
    isShimmering: isShimmering
  }, function (_ref2) {
    var className = _ref2.className;
    return (0, _react.jsx)("div", {
      className: className,
      style: {
        '--width': width
      },
      css: [skeletonStyles, (hasAvatar || hasIcon) && beforeElementStyles, hasAvatar && avatarStyles, hasIcon && iconStyles, width ? customWidthStyles : defaultWidthStyles,
      // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
      (0, _react.css)(cssFn())],
      "data-testid": testId
    });
  });
};
var _default = SkeletonItem;
exports.default = _default;