"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _deprecationWarning = require("@atlaskit/ds-lib/deprecation-warning");
var _colors = require("@atlaskit/theme/colors");
var _constants = require("@atlaskit/theme/constants");
var _typography = require("@atlaskit/theme/typography");
var _headingItem = _interopRequireDefault(require("../menu-item/heading-item"));
var _excluded = ["children", "overrides", "title", "testId", "isScrollable", "hasSeparator", "id", "isList"];
/* eslint-disable @atlaskit/design-system/ensure-design-token-usage */
/** @jsx jsx */
// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
var gridSize = (0, _constants.gridSize)();
var itemHeadingTopMargin = gridSize * 2.5;
var itemHeadingBottomMargin = gridSize * 0.75;
// Skeleton content is slightly shorter than the real content.
// Because of that we slightly increase the top margin to offset this so the
// containing size both real and skeleton always equal approx 30px.
var itemHeadingContentHeight = _typography.headingSizes.h100.lineHeight;
var skeletonHeadingHeight = gridSize;
var skeletonHeadingMarginOffset = 3;
var skeletonHeadingTopMargin = itemHeadingTopMargin + (itemHeadingContentHeight - skeletonHeadingHeight) - skeletonHeadingMarginOffset;
// We want to move the entire body up by 3px without affecting the height of the skeleton container.
var skeletonHeadingBottomMargin = itemHeadingBottomMargin + skeletonHeadingMarginOffset;
var sectionPaddingTopBottom = gridSize * 0.75;
var VAR_SEPARATOR_COLOR = '--ds-menu-seperator-color';
var sectionStyles = (0, _react2.css)({
  '&::before, &::after': {
    display: 'block',
    height: sectionPaddingTopBottom,
    content: '""'
  },
  // eslint-disable-next-line @repo/internal/styles/no-nested-styles
  '& [data-ds--menu--heading-item]': {
    marginTop: itemHeadingTopMargin,
    marginBottom: itemHeadingBottomMargin,
    '&:first-of-type': {
      marginTop: itemHeadingTopMargin - sectionPaddingTopBottom
    }
  },
  // eslint-disable-next-line @repo/internal/styles/no-nested-styles
  '& [data-ds--menu--skeleton-heading-item]': {
    marginTop: skeletonHeadingTopMargin,
    marginBottom: skeletonHeadingBottomMargin,
    '&:first-of-type': {
      marginTop: skeletonHeadingTopMargin - sectionPaddingTopBottom
    }
  },
  '&:focus': {
    // NOTE: Firefox allows elements that have "overflow: auto" to gain focus (as if it had tab-index="0")
    // We have made a deliberate choice to leave this behaviour as is.
    // This makes the outline go inside by 1px so it can actually be displayed
    // else it gets cut off from the overflow: scroll from the parent menu group.
    outlineOffset: -1
  }
});
var scrollableStyles = (0, _react2.css)({
  flexShrink: 1,
  overflow: 'auto'
});
var unscrollableStyles = (0, _react2.css)({
  flexShrink: 0
});
var separatorStyles = (0, _react2.css)({
  borderTop: "2px solid var(".concat(VAR_SEPARATOR_COLOR, ", ", "var(--ds-border, ".concat(_colors.N30A, ")"), ")")
});
var noSeparatorStyles = (0, _react2.css)({
  // this is to ensure that adjacent sections without separators don't get additional margins.
  // eslint-disable-next-line @repo/internal/styles/no-nested-styles
  '[data-section] + &': {
    marginTop: -6
  }
});

/**
 * __Section__
 *
 * A section includes related actions or items in a menu.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/section)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var Section = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
    overrides = _ref.overrides,
    title = _ref.title,
    testId = _ref.testId,
    isScrollable = _ref.isScrollable,
    hasSeparator = _ref.hasSeparator,
    id = _ref.id,
    _ref$isList = _ref.isList,
    isList = _ref$isList === void 0 ? false : _ref$isList,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  (0, _deprecationWarning.propDeprecationWarning)("@atlaskit/menu", 'overrides', overrides !== undefined, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  var content = isList ? (0, _react2.jsx)("ul", {
    style: {
      margin: 0,
      padding: 0
    }
  }, _react.Children.map(_react.Children.toArray(children), function (child, index) {
    return (0, _react2.jsx)("li", {
      style: {
        listStyleType: 'none',
        margin: 0,
        padding: 0
      },
      key: index
    }, child);
  })) : children;
  var childrenMarkup = title !== undefined ? (0, _react2.jsx)(_react.Fragment, null, (0, _react2.jsx)(_headingItem.default
  // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
  , {
    cssFn: overrides && overrides.HeadingItem && overrides.HeadingItem.cssFn,
    testId: testId && "".concat(testId, "--heading"),
    "aria-hidden": true
  }, title), content) : (0, _react2.jsx)(_react.Fragment, null, content);
  return (0, _react2.jsx)("div", (0, _extends2.default)({}, rest, {
    id: id
    // NOTE: Firefox allows elements that have "overflow: auto" to gain focus (as if it had tab-index="0")
    // We have made a deliberate choice to leave this behaviour as is.
    ,
    css: [sectionStyles, isScrollable ? scrollableStyles : unscrollableStyles, hasSeparator ? separatorStyles : noSeparatorStyles],
    "aria-label": title,
    "data-testid": testId,
    role: "group",
    "data-section": true,
    ref: ref
  }), childrenMarkup);
});
var _default = Section;
exports.default = _default;