import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */
import { memo } from 'react';
import { css, jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import noop from '@atlaskit/ds-lib/noop';
import { N300 } from '@atlaskit/theme/colors';
import { headingSizes } from '@atlaskit/theme/typography';
const itemHeadingContentHeight = headingSizes.h100.lineHeight;
const itemHeadingFontSize = headingSizes.h100.size;
const headingStyles = css({
  color: `var(--ds-text-subtle, ${N300})`,
  fontSize: itemHeadingFontSize,
  fontWeight: "var(--ds-font-weight-bold, 700)",
  lineHeight: itemHeadingContentHeight / itemHeadingFontSize,
  paddingBlock: "var(--ds-space-0, 0px)",
  paddingInline: "var(--ds-space-200, 16px)",
  textTransform: 'uppercase'
});

/**
 * __Heading item__
 *
 * A heading item is used to describe sibling menu items.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/heading-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
const HeadingItem = /*#__PURE__*/memo(({
  children,
  testId,
  id,
  cssFn = noop,
  ...rest
}) => {
  propDeprecationWarning("@atlaskit/menu", 'cssFn', cssFn !== noop, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return jsx("div", _extends({
    css: [headingStyles,
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    css(cssFn(undefined))],
    "data-testid": testId,
    "data-ds--menu--heading-item": true,
    id: id
  }, rest), children);
});
export default HeadingItem;