import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */
import { forwardRef, memo } from 'react';
import { jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import noop from '@atlaskit/ds-lib/noop';
import MenuItemPrimitive from '../internal/components/menu-item-primitive';
const preventEvent = e => {
  e.preventDefault();
};

/**
 * __Link item__
 *
 * A link item is used to populate a menu with items that are links.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/link-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
const LinkItem = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(
// Type needed on props to extract types with extract react types.
(props, ref) => {
  const {
    children,
    href,
    cssFn = noop,
    description,
    iconAfter,
    iconBefore,
    isDisabled = false,
    isSelected = false,
    onClick,
    testId,
    overrides,
    onMouseDown,
    shouldTitleWrap,
    shouldDescriptionWrap,
    ...rest
  } = props;
  const onMouseDownHandler = onMouseDown;
  if (!children) {
    return null;
  }
  propDeprecationWarning("@atlaskit/menu", 'cssFn', cssFn !== noop, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return jsx(MenuItemPrimitive, _extends({}, rest, {
    // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
    overrides: overrides,
    iconBefore: iconBefore,
    iconAfter: iconAfter,
    isSelected: isSelected,
    isDisabled: isDisabled,
    description: description,
    shouldTitleWrap: shouldTitleWrap,
    shouldDescriptionWrap: shouldDescriptionWrap,
    css:
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    cssFn({
      isSelected,
      isDisabled
    }),
    title: children
  }), ({
    children,
    className
  }) => jsx("a", _extends({
    "data-testid": testId
  }, rest, {
    className: className,
    href: isDisabled ? undefined : href,
    draggable: false,
    onDragStart: preventEvent,
    onMouseDown: isDisabled ? preventEvent : onMouseDownHandler,
    onClick: isDisabled ? preventEvent : onClick,
    "aria-current": isSelected ? 'page' : undefined,
    "aria-disabled": isDisabled,
    ref: ref
  }), children));
}));
export default LinkItem;