/** @jsx jsx */

import { css, jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import noop from '@atlaskit/ds-lib/noop';
import { N20A } from '@atlaskit/theme/colors';
import SkeletonShimmer from '../internal/components/skeleton-shimmer';
const skeletonStyles = css({
  paddingBlock: "var(--ds-space-0, 0px)",
  paddingInline: "var(--ds-space-200, 16px)",
  '::after': {
    display: 'block',
    width: '30%',
    height: "var(--ds-space-100, 8px)",
    backgroundColor: `var(--ds-skeleton, ${N20A})`,
    borderRadius: 100,
    content: '""'
  }
});
const defaultWidthStyles = css({
  '::after': {
    width: '30%'
  }
});
const customWidthStyles = css({
  '::after': {
    width: 'var(--width)'
  }
});

/**
 * __Skeleton heading item__
 *
 * A skeleton heading item is used in place of a heading item when its contents it not ready.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/skeleton-heading-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
const SkeletonHeadingItem = ({
  isShimmering = false,
  testId,
  width,
  cssFn = noop
}) => {
  propDeprecationWarning("@atlaskit/menu", 'cssFn', cssFn !== noop, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return jsx(SkeletonShimmer, {
    isShimmering: isShimmering
  }, ({
    className
  }) => jsx("div", {
    className: className,
    style: {
      '--width': width
    },
    css: [skeletonStyles, width ? customWidthStyles : defaultWidthStyles,
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    css(cssFn(undefined))],
    "data-ds--menu--skeleton-heading-item": true,
    "data-testid": testId
  }));
};
export default SkeletonHeadingItem;