import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */
import { jsx } from '@emotion/react';
import { UNSAFE_Box as Box } from '@atlaskit/ds-explorations';
import { SELECTION_STYLE_CONTEXT_DO_NOT_USE, SpacingContext } from '../internal/components/menu-context';
/**
 * __Menu group__
 *
 * A menu group includes all the actions or items in a menu.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/menu-group)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
const MenuGroup = ({
  maxWidth,
  minWidth,
  minHeight,
  maxHeight,
  testId,
  role,
  spacing = 'cozy',
  ...rest
}) => jsx(SpacingContext.Provider, {
  value: spacing
}, jsx(SELECTION_STYLE_CONTEXT_DO_NOT_USE.Provider, {
  value: "border"
}, jsx(Box, _extends({
  UNSAFE_style: {
    minWidth,
    maxWidth,
    minHeight,
    maxHeight
  },
  display: "flex",
  flexDirection: "column",
  overflow: "auto",
  testId: testId,
  role: role,
  position: "static"
  // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
}, rest))));
export default MenuGroup;