/** @jsx jsx */

import { ClassNames, css, jsx, keyframes } from '@emotion/react';
import { N20A, N30A } from '@atlaskit/theme/colors';
/**
 * These keyframes are mirrored in:
 * packages/design-system/theme/src/constants.tsx
 *
 * Please update both.
 */
var shimmerKeyframes = keyframes({
  from: {
    backgroundColor: "var(--ds-skeleton, ".concat(N20A, ")")
  },
  to: {
    backgroundColor: "var(--ds-skeleton-subtle, ".concat(N30A, ")")
  }
});

/**
 * These styles are mirrored in:
 * packages/design-system/theme/src/constants.tsx
 *
 * Please update both.
 */
var shimmerStyles = css({
  '::before, ::after': {
    animationDirection: 'alternate',
    animationDuration: '1.5s',
    animationIterationCount: 'infinite',
    animationName: "".concat(shimmerKeyframes),
    animationTimingFunction: 'linear',
    backgroundColor: "var(--ds-skeleton, ".concat(N20A, ")")
  }
});

/**
 * __Skeleton shimmer__
 *
 * A skeleton shimmer is the animation shown on loading skeletons for
 * perceived performance and user satisfaction.
 *
 * This component provides a `className` through render props. This value will
 * have type:
 * + `string`, when `isShimmering={true}`.
 * + `undefined`, when `isShimmering={false}`.
 *
 * @internal
 */
var SkeletonShimmer = function SkeletonShimmer(_ref) {
  var children = _ref.children,
    _ref$isShimmering = _ref.isShimmering,
    isShimmering = _ref$isShimmering === void 0 ? false : _ref$isShimmering;
  return jsx(ClassNames, null, function (_ref2) {
    var css = _ref2.css;
    return children({
      className: isShimmering ? css(shimmerStyles) : undefined
    });
  });
};
export default SkeletonShimmer;