import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "cssFn", "description", "iconAfter", "iconBefore", "isDisabled", "isSelected", "onClick", "testId", "overrides", "onMouseDown", "shouldTitleWrap", "shouldDescriptionWrap"];
/** @jsx jsx */
import { forwardRef, memo } from 'react';
import { jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import noop from '@atlaskit/ds-lib/noop';
import MenuItemPrimitive from '../internal/components/menu-item-primitive';
/**
 * __Button item__
 *
 * A button item is used to populate a menu with items that are buttons.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/button-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var ButtonItem = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(
// Type needed on props to extract types with extract react types.
function (props, ref) {
  var children = props.children,
    _props$cssFn = props.cssFn,
    cssFn = _props$cssFn === void 0 ? noop : _props$cssFn,
    description = props.description,
    iconAfter = props.iconAfter,
    iconBefore = props.iconBefore,
    _props$isDisabled = props.isDisabled,
    isDisabled = _props$isDisabled === void 0 ? false : _props$isDisabled,
    _props$isSelected = props.isSelected,
    isSelected = _props$isSelected === void 0 ? false : _props$isSelected,
    onClick = props.onClick,
    testId = props.testId,
    overrides = props.overrides,
    onMouseDown = props.onMouseDown,
    shouldTitleWrap = props.shouldTitleWrap,
    shouldDescriptionWrap = props.shouldDescriptionWrap,
    rest = _objectWithoutProperties(props, _excluded);
  var onMouseDownHandler = onMouseDown;
  if (!children) {
    return null;
  }
  propDeprecationWarning("@atlaskit/menu", 'cssFn', cssFn !== noop, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return jsx(MenuItemPrimitive, _extends({}, rest, {
    // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
    overrides: overrides,
    iconBefore: iconBefore,
    iconAfter: iconAfter,
    isDisabled: isDisabled,
    isSelected: isSelected,
    description: description,
    title: children,
    shouldTitleWrap: shouldTitleWrap,
    shouldDescriptionWrap: shouldDescriptionWrap,
    css:
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    cssFn({
      isSelected: isSelected,
      isDisabled: isDisabled
    })
  }), function (_ref) {
    var children = _ref.children,
      className = _ref.className;
    return jsx("button", _extends({
      "data-testid": testId
    }, rest, {
      className: className,
      ref: ref,
      disabled: isDisabled,
      onClick: onClick,
      onMouseDown: onMouseDownHandler,
      type: "button"
    }), children);
  });
}));
export default ButtonItem;