/** @jsx jsx */

import { css, jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import noop from '@atlaskit/ds-lib/noop';
import { N20A } from '@atlaskit/theme/colors';
import { borderRadius as borderRadiusFn,
// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
gridSize as gridSizeFn } from '@atlaskit/theme/constants';
import SkeletonShimmer from '../internal/components/skeleton-shimmer';
var gridSize = gridSizeFn();
var borderRadius = borderRadiusFn();
var itemElemSpacing = gridSize * 1.5;
var itemExpectedElemSize = gridSize * 3;
var itemMinHeight = gridSize * 5;
var skeletonItemElemSize = gridSize * 2.5;
var itemElemSkeletonOffset = (itemExpectedElemSize - skeletonItemElemSize) / 2;
var skeletonTextBorderRadius = 100;
var skeletonContentHeight = 9;
var skeletonColor = "var(--ds-skeleton, ".concat(N20A, ")");
var skeletonStyles = css({
  display: 'flex',
  minHeight: itemMinHeight,
  padding: "0 ".concat("var(--ds-space-250, 20px)"),
  alignItems: 'center',
  pointerEvents: 'none',
  '::after': {
    height: skeletonContentHeight,
    // This is a little bespoke but we need to push everything down 1px
    // because the skeleton content should align to the bottom of the text.
    // Confirm VR test failures before accepting a change.
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    marginTop: 1,
    backgroundColor: skeletonColor,
    borderRadius: skeletonTextBorderRadius,
    content: '""'
  }
});
var defaultWidthStyles = css({
  ':nth-of-type(1n)::after': {
    flexBasis: '70%'
  },
  ':nth-of-type(2n)::after': {
    flexBasis: '50%'
  },
  ':nth-of-type(3n)::after': {
    flexBasis: '60%'
  },
  ':nth-of-type(4n)::after': {
    flexBasis: '90%'
  },
  ':nth-of-type(5n)::after': {
    flexBasis: '35%'
  },
  ':nth-of-type(6n)::after': {
    flexBasis: '77%'
  }
});
var customWidthStyles = css({
  '::after': {
    flexBasis: 'var(--width)'
  }
});
var beforeElementStyles = css({
  '::before': {
    width: skeletonItemElemSize,
    height: skeletonItemElemSize,
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    marginRight: itemElemSpacing + itemElemSkeletonOffset,
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    marginLeft: itemElemSkeletonOffset,
    flexShrink: 0,
    backgroundColor: skeletonColor,
    content: '""'
  }
});
var avatarStyles = css({
  '::before': {
    borderRadius: '100%'
  }
});
var iconStyles = css({
  '::before': {
    borderRadius: borderRadius
  }
});

/**
 * __Skeleton item__
 *
 * A skeleton item is used in place of an item when its contents it not ready.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/skeleton-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var SkeletonItem = function SkeletonItem(_ref) {
  var hasAvatar = _ref.hasAvatar,
    hasIcon = _ref.hasIcon,
    _ref$isShimmering = _ref.isShimmering,
    isShimmering = _ref$isShimmering === void 0 ? false : _ref$isShimmering,
    testId = _ref.testId,
    width = _ref.width,
    _ref$cssFn = _ref.cssFn,
    cssFn = _ref$cssFn === void 0 ? noop : _ref$cssFn;
  propDeprecationWarning("@atlaskit/menu", 'cssFn', cssFn !== noop, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return jsx(SkeletonShimmer, {
    isShimmering: isShimmering
  }, function (_ref2) {
    var className = _ref2.className;
    return jsx("div", {
      className: className,
      style: {
        '--width': width
      },
      css: [skeletonStyles, (hasAvatar || hasIcon) && beforeElementStyles, hasAvatar && avatarStyles, hasIcon && iconStyles, width ? customWidthStyles : defaultWidthStyles,
      // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
      css(cssFn())],
      "data-testid": testId
    });
  });
};
export default SkeletonItem;