/** @jsx jsx */
import { ReactNode } from 'react';
import { jsx } from '@emotion/react';
type SkeletonShimmerProps = {
    children: ({ className }: {
        className?: string;
    }) => ReactNode;
    isShimmering?: boolean;
};
/**
 * __Skeleton shimmer__
 *
 * A skeleton shimmer is the animation shown on loading skeletons for
 * perceived performance and user satisfaction.
 *
 * This component provides a `className` through render props. This value will
 * have type:
 * + `string`, when `isShimmering={true}`.
 * + `undefined`, when `isShimmering={false}`.
 *
 * @internal
 */
declare const SkeletonShimmer: ({ children, isShimmering, }: SkeletonShimmerProps) => jsx.JSX.Element;
export default SkeletonShimmer;
