import { jsx } from '@emotion/react';
import type { MenuItemPrimitiveProps } from '../../types';
/**
 * __Menu item primitive__
 *
 * Menu item primitive contains all the styles for menu items,
 * including support for selected, disabled, and interaction states.
 *
 * Using children as function prop you wire up this to your own host element.
 *
 * ```jsx
 * <MenuItemPrimitive>
 *   {({ children, ...props }) => <button {...props}>{children}</button>}
 * </MenuItemPrimitive>
 * ```
 */
declare const MenuItemPrimitive: ({ children, title, description, iconAfter, iconBefore, overrides, className, shouldTitleWrap, shouldDescriptionWrap, isDisabled, isSelected, }: MenuItemPrimitiveProps) => jsx.JSX.Element;
export default MenuItemPrimitive;
