"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _deprecationWarning = require("@atlaskit/ds-lib/deprecation-warning");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _menuItemPrimitive = _interopRequireDefault(require("../internal/components/menu-item-primitive"));
var _excluded = ["children", "href", "cssFn", "description", "iconAfter", "iconBefore", "isDisabled", "isSelected", "onClick", "testId", "overrides", "onMouseDown", "shouldTitleWrap", "shouldDescriptionWrap"];
/** @jsx jsx */
var preventEvent = function preventEvent(e) {
  e.preventDefault();
};

/**
 * __Link item__
 *
 * A link item is used to populate a menu with items that are links.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/link-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var LinkItem = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(
// Type needed on props to extract types with extract react types.
function (props, ref) {
  var children = props.children,
    href = props.href,
    _props$cssFn = props.cssFn,
    cssFn = _props$cssFn === void 0 ? _noop.default : _props$cssFn,
    description = props.description,
    iconAfter = props.iconAfter,
    iconBefore = props.iconBefore,
    _props$isDisabled = props.isDisabled,
    isDisabled = _props$isDisabled === void 0 ? false : _props$isDisabled,
    _props$isSelected = props.isSelected,
    isSelected = _props$isSelected === void 0 ? false : _props$isSelected,
    onClick = props.onClick,
    testId = props.testId,
    overrides = props.overrides,
    onMouseDown = props.onMouseDown,
    shouldTitleWrap = props.shouldTitleWrap,
    shouldDescriptionWrap = props.shouldDescriptionWrap,
    rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var onMouseDownHandler = onMouseDown;
  if (!children) {
    return null;
  }
  (0, _deprecationWarning.propDeprecationWarning)("@atlaskit/menu", 'cssFn', cssFn !== _noop.default, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return (0, _react2.jsx)(_menuItemPrimitive.default, (0, _extends2.default)({}, rest, {
    // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
    overrides: overrides,
    iconBefore: iconBefore,
    iconAfter: iconAfter,
    isSelected: isSelected,
    isDisabled: isDisabled,
    description: description,
    shouldTitleWrap: shouldTitleWrap,
    shouldDescriptionWrap: shouldDescriptionWrap,
    css:
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    cssFn({
      isSelected: isSelected,
      isDisabled: isDisabled
    }),
    title: children
  }), function (_ref) {
    var children = _ref.children,
      className = _ref.className;
    return (0, _react2.jsx)("a", (0, _extends2.default)({
      "data-testid": testId
    }, rest, {
      className: className,
      href: isDisabled ? undefined : href,
      draggable: false,
      onDragStart: preventEvent,
      onMouseDown: isDisabled ? preventEvent : onMouseDownHandler,
      onClick: isDisabled ? preventEvent : onClick,
      "aria-current": isSelected ? 'page' : undefined,
      "aria-disabled": isDisabled,
      ref: ref
    }), children);
  });
}));
var _default = LinkItem;
exports.default = _default;