import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */

import { forwardRef, memo } from 'react';
import { css, jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import noop from '@atlaskit/ds-lib/noop';
import MenuItemPrimitive from '../internal/components/menu-item-primitive';
const preventEvent = e => {
  e.preventDefault();
};

// Dirty hack to get generics working with forward ref [1/2]

/**
 * __Custom item__
 *
 * A custom item is used to populate a menu with items that can be any element.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/custom-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
const CustomItem = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(({
  component: Component,
  cssFn = noop,
  isDisabled = false,
  isSelected = false,
  onClick,
  testId,
  children,
  description,
  iconAfter,
  iconBefore,
  overrides,
  onMouseDown,
  shouldTitleWrap,
  shouldDescriptionWrap,
  ...rest
}, ref) => {
  const onMouseDownHandler = onMouseDown;
  if (!Component) {
    return null;
  }
  propDeprecationWarning("@atlaskit/menu", 'cssFn', cssFn !== noop, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return jsx(MenuItemPrimitive, _extends({}, rest, {
    // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
    overrides: overrides,
    description: description,
    iconAfter: iconAfter,
    title: children,
    iconBefore: iconBefore,
    isSelected: isSelected,
    isDisabled: isDisabled,
    shouldTitleWrap: shouldTitleWrap,
    shouldDescriptionWrap: shouldDescriptionWrap
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    ,
    css: css(cssFn({
      isDisabled,
      isSelected
    }))
  }), ({
    children,
    className
  }) => jsx(Component, _extends({
    "data-testid": testId
  }, rest, {
    className: className,
    ref: ref,
    draggable: false,
    onDragStart: preventEvent,
    onMouseDown: isDisabled ? preventEvent : onMouseDownHandler,
    onClick: isDisabled ? preventEvent : onClick,
    tabIndex: isDisabled ? -1 : undefined,
    "aria-disabled": isDisabled
  }), children));
})
// Dirty hack to get generics working with forward ref [2/2]
);

export default CustomItem;