/** @jsx jsx */
import { useContext } from 'react';
import { ClassNames, css, jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import FocusRing from '@atlaskit/focus-ring';
import { getBooleanFF } from '@atlaskit/platform-feature-flags';
import Inline from '@atlaskit/primitives/inline';
import { N20, N200, N30 } from '@atlaskit/theme/colors';
import { SELECTION_STYLE_CONTEXT_DO_NOT_USE, SpacingContext } from './menu-context';
var defaultRender = function defaultRender(Component, props) {
  return (
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
    jsx(Component, props)
  );
};
var beforeAfterElementStyles = css({
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  flexShrink: 0
});
var contentStyles = css({
  display: 'flex',
  justifyContent: 'center',
  flexDirection: 'column',
  flexGrow: 1,
  // Fix - avoid clipped text descenders when using standard 16px line-height
  lineHeight: "var(--ds-font-lineHeight-100, 16px)",
  outline: 'none',
  overflow: 'hidden',
  textAlign: 'left'
});
var truncateStyles = css({
  display: 'block',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
  whiteSpace: 'nowrap'
});
var wordBreakStyles = css({
  wordBreak: 'break-word'
});
var descriptionStyles = css({
  marginTop: "var(--ds-space-050, 4px)",
  color: "var(--ds-text-subtlest, ".concat(N200, ")"),
  fontSize: "var(--ds-font-size-075, 12px)"
});
var disabledDescriptionStyles = css({
  color: "var(--ds-text-disabled, ".concat(N200, ")")
});
var positionRelativeStyles = css({
  position: 'relative'
});
var primitiveStyles = css({
  display: 'flex',
  boxSizing: 'border-box',
  width: '100%',
  minHeight: 40,
  margin: "var(--ds-space-0, 0px)",
  alignItems: 'center',
  border: 0,
  fontSize: "var(--ds-font-size-100, 14px)",
  outline: 0,
  textDecoration: 'none',
  userSelect: 'none',
  '::-moz-focus-inner': {
    border: 0
  },
  ':hover': {
    textDecoration: 'none'
  }
});
var spacingMapStyles = {
  cozy: css({
    // 8 * 2 (16) + icon (24) === 40
    paddingBlock: "var(--ds-space-100, 8px)",
    paddingInline: "var(--ds-space-200, 16px)"
  }),
  compact: css({
    minHeight: 32,
    maxHeight: 32,
    // 4 * 2 (8) + icon (24) === 32
    paddingBlock: "var(--ds-space-050, 4px)",
    paddingInline: "var(--ds-space-150, 12px)"
  })
};
var interactiveStyles = css({
  cursor: 'pointer'
});
var unselectedStyles = css({
  backgroundColor: "var(--ds-background-neutral-subtle, transparent)",
  color: 'currentColor',
  ':visited': {
    color: 'currentColor'
  },
  ':hover': {
    backgroundColor: "var(--ds-background-neutral-subtle-hovered, ".concat(N20, ")"),
    color: 'currentColor'
  },
  ':active': {
    backgroundColor: "var(--ds-background-neutral-subtle-pressed, ".concat(N30, ")"),
    boxShadow: 'none',
    color: 'currentColor'
  }
});
var disabledStyles = css({
  cursor: 'not-allowed',
  '&, :hover, :active': {
    backgroundColor: "var(--ds-background-neutral-subtle, transparent)",
    color: "var(--ds-text-disabled, ".concat(N200, ")")
  }
});
var selectedBorderStyles = css({
  '&::before': {
    width: 2,
    position: 'absolute',
    top: 0,
    bottom: 0,
    left: 0,
    background: "var(--ds-border-selected, transparent)",
    content: '""'
  }
});
var selectedNotchStyles = css({
  '&::before': {
    width: 4,
    position: 'absolute',
    top: "var(--ds-space-150, 12px)",
    bottom: "var(--ds-space-150, 12px)",
    left: 0,
    background: "var(--ds-border-selected, transparent)",
    borderRadius: "0 ".concat("var(--ds-border-radius, 4px)", " ", "var(--ds-border-radius, 4px)", " 0"),
    content: '""'
  }
});
var selectedStyles = css({
  backgroundColor: "var(--ds-background-selected, ".concat(N20, ")"),
  // Fallback set as babel plugin inserts one otherwise
  color: "var(--ds-text-selected, currentColor)",
  ':visited': {
    color: "var(--ds-text-selected, currentColor)"
  },
  ':hover': {
    backgroundColor: "var(--ds-background-selected-hovered, ".concat(N20, ")"),
    color: "var(--ds-text-selected, currentColor)"
  },
  ':active': {
    backgroundColor: "var(--ds-background-selected-pressed, ".concat(N30, ")"),
    color: "var(--ds-text-selected, currentColor)"
  }
});
var gapMap = {
  compact: 'space.100',
  cozy: 'space.150'
};

/**
 * __Menu item primitive__
 *
 * Menu item primitive contains all the styles for menu items,
 * including support for selected, disabled, and interaction states.
 *
 * Using children as function prop you wire up this to your own host element.
 *
 * ```jsx
 * <MenuItemPrimitive>
 *   {({ children, ...props }) => <button {...props}>{children}</button>}
 * </MenuItemPrimitive>
 * ```
 */
var MenuItemPrimitive = function MenuItemPrimitive(_ref) {
  var children = _ref.children,
    title = _ref.title,
    description = _ref.description,
    iconAfter = _ref.iconAfter,
    iconBefore = _ref.iconBefore,
    overrides = _ref.overrides,
    className = _ref.className,
    _ref$shouldTitleWrap = _ref.shouldTitleWrap,
    shouldTitleWrap = _ref$shouldTitleWrap === void 0 ? false : _ref$shouldTitleWrap,
    _ref$shouldDescriptio = _ref.shouldDescriptionWrap,
    shouldDescriptionWrap = _ref$shouldDescriptio === void 0 ? false : _ref$shouldDescriptio,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected;
  propDeprecationWarning("@atlaskit/menu", 'overrides', overrides !== undefined, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  var spacing = useContext(SpacingContext);
  var selectionStyle = useContext(SELECTION_STYLE_CONTEXT_DO_NOT_USE);
  var renderTitle = overrides && overrides.Title && overrides.Title.render || defaultRender;
  return jsx(ClassNames, null, function (_ref2) {
    var cn = _ref2.css,
      cx = _ref2.cx;
    return jsx(FocusRing, {
      isInset: true
    }, children({
      className: cx([cn([getBooleanFF('platform.design-system-team.menu-selected-state-change_0see9') && positionRelativeStyles, primitiveStyles, spacingMapStyles[spacing], !isDisabled && !isSelected && unselectedStyles, !isDisabled && isSelected && [selectedStyles, getBooleanFF('platform.design-system-team.menu-selected-state-change_0see9') && [selectionStyle === 'border' && selectedBorderStyles, selectionStyle === 'notch' && selectedNotchStyles]], isDisabled ? disabledStyles : interactiveStyles]), className]),
      children: jsx(Inline, {
        as: "span",
        spread: "space-between",
        alignBlock: "center",
        space: gapMap[spacing],
        grow: "fill"
      }, iconBefore && jsx("span", {
        "data-item-elem-before": true,
        css: beforeAfterElementStyles
      }, iconBefore), title && jsx("span", {
        css: contentStyles
      }, renderTitle('span', {
        children: title,
        className: cn(shouldTitleWrap ? wordBreakStyles : truncateStyles),
        'data-item-title': true
      }), description && jsx("span", {
        "data-item-description": true,
        css: [descriptionStyles, isDisabled && disabledDescriptionStyles, shouldDescriptionWrap ? wordBreakStyles : truncateStyles]
      }, description)), iconAfter && jsx("span", {
        "data-item-elem-after": true,
        css: beforeAfterElementStyles
      }, iconAfter))
    }));
  });
};
export default MenuItemPrimitive;