import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["component", "cssFn", "isDisabled", "isSelected", "onClick", "testId", "children", "description", "iconAfter", "iconBefore", "overrides", "onMouseDown", "shouldTitleWrap", "shouldDescriptionWrap"];
/** @jsx jsx */

import { forwardRef, memo } from 'react';
import { css, jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import noop from '@atlaskit/ds-lib/noop';
import MenuItemPrimitive from '../internal/components/menu-item-primitive';
var preventEvent = function preventEvent(e) {
  e.preventDefault();
};

// Dirty hack to get generics working with forward ref [1/2]

/**
 * __Custom item__
 *
 * A custom item is used to populate a menu with items that can be any element.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/custom-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var CustomItem = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (_ref, ref) {
  var Component = _ref.component,
    _ref$cssFn = _ref.cssFn,
    cssFn = _ref$cssFn === void 0 ? noop : _ref$cssFn,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    onClick = _ref.onClick,
    testId = _ref.testId,
    children = _ref.children,
    description = _ref.description,
    iconAfter = _ref.iconAfter,
    iconBefore = _ref.iconBefore,
    overrides = _ref.overrides,
    onMouseDown = _ref.onMouseDown,
    shouldTitleWrap = _ref.shouldTitleWrap,
    shouldDescriptionWrap = _ref.shouldDescriptionWrap,
    rest = _objectWithoutProperties(_ref, _excluded);
  var onMouseDownHandler = onMouseDown;
  if (!Component) {
    return null;
  }
  propDeprecationWarning("@atlaskit/menu", 'cssFn', cssFn !== noop, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return jsx(MenuItemPrimitive, _extends({}, rest, {
    // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
    overrides: overrides,
    description: description,
    iconAfter: iconAfter,
    title: children,
    iconBefore: iconBefore,
    isSelected: isSelected,
    isDisabled: isDisabled,
    shouldTitleWrap: shouldTitleWrap,
    shouldDescriptionWrap: shouldDescriptionWrap
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    ,
    css: css(cssFn({
      isDisabled: isDisabled,
      isSelected: isSelected
    }))
  }), function (_ref2) {
    var children = _ref2.children,
      className = _ref2.className;
    return jsx(Component, _extends({
      "data-testid": testId
    }, rest, {
      className: className,
      ref: ref,
      draggable: false,
      onDragStart: preventEvent,
      onMouseDown: isDisabled ? preventEvent : onMouseDownHandler,
      onClick: isDisabled ? preventEvent : onClick,
      tabIndex: isDisabled ? -1 : undefined,
      "aria-disabled": isDisabled
    }), children);
  });
})
// Dirty hack to get generics working with forward ref [2/2]
);

export default CustomItem;