import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "testId", "id", "cssFn"];
/** @jsx jsx */
import { memo } from 'react';
import { css, jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import noop from '@atlaskit/ds-lib/noop';
import { N300 } from '@atlaskit/theme/colors';
import { headingSizes } from '@atlaskit/theme/typography';
var itemHeadingContentHeight = headingSizes.h100.lineHeight;
var itemHeadingFontSize = headingSizes.h100.size;
var headingStyles = css({
  color: "var(--ds-text-subtle, ".concat(N300, ")"),
  fontSize: itemHeadingFontSize,
  fontWeight: "var(--ds-font-weight-bold, 700)",
  lineHeight: itemHeadingContentHeight / itemHeadingFontSize,
  paddingBlock: "var(--ds-space-0, 0px)",
  paddingInline: "var(--ds-space-200, 16px)",
  textTransform: 'uppercase'
});

/**
 * __Heading item__
 *
 * A heading item is used to describe sibling menu items.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/heading-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var HeadingItem = /*#__PURE__*/memo(function (_ref) {
  var children = _ref.children,
    testId = _ref.testId,
    id = _ref.id,
    _ref$cssFn = _ref.cssFn,
    cssFn = _ref$cssFn === void 0 ? noop : _ref$cssFn,
    rest = _objectWithoutProperties(_ref, _excluded);
  propDeprecationWarning("@atlaskit/menu", 'cssFn', cssFn !== noop, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return jsx("div", _extends({
    css: [headingStyles,
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    css(cssFn(undefined))],
    "data-testid": testId,
    "data-ds--menu--heading-item": true,
    id: id
  }, rest), children);
});
export default HeadingItem;