import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "href", "cssFn", "description", "iconAfter", "iconBefore", "isDisabled", "isSelected", "onClick", "testId", "overrides", "onMouseDown", "shouldTitleWrap", "shouldDescriptionWrap"];
/** @jsx jsx */
import { forwardRef, memo } from 'react';
import { jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import noop from '@atlaskit/ds-lib/noop';
import MenuItemPrimitive from '../internal/components/menu-item-primitive';
var preventEvent = function preventEvent(e) {
  e.preventDefault();
};

/**
 * __Link item__
 *
 * A link item is used to populate a menu with items that are links.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/link-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var LinkItem = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(
// Type needed on props to extract types with extract react types.
function (props, ref) {
  var children = props.children,
    href = props.href,
    _props$cssFn = props.cssFn,
    cssFn = _props$cssFn === void 0 ? noop : _props$cssFn,
    description = props.description,
    iconAfter = props.iconAfter,
    iconBefore = props.iconBefore,
    _props$isDisabled = props.isDisabled,
    isDisabled = _props$isDisabled === void 0 ? false : _props$isDisabled,
    _props$isSelected = props.isSelected,
    isSelected = _props$isSelected === void 0 ? false : _props$isSelected,
    onClick = props.onClick,
    testId = props.testId,
    overrides = props.overrides,
    onMouseDown = props.onMouseDown,
    shouldTitleWrap = props.shouldTitleWrap,
    shouldDescriptionWrap = props.shouldDescriptionWrap,
    rest = _objectWithoutProperties(props, _excluded);
  var onMouseDownHandler = onMouseDown;
  if (!children) {
    return null;
  }
  propDeprecationWarning("@atlaskit/menu", 'cssFn', cssFn !== noop, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return jsx(MenuItemPrimitive, _extends({}, rest, {
    // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
    overrides: overrides,
    iconBefore: iconBefore,
    iconAfter: iconAfter,
    isSelected: isSelected,
    isDisabled: isDisabled,
    description: description,
    shouldTitleWrap: shouldTitleWrap,
    shouldDescriptionWrap: shouldDescriptionWrap,
    css:
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    cssFn({
      isSelected: isSelected,
      isDisabled: isDisabled
    }),
    title: children
  }), function (_ref) {
    var children = _ref.children,
      className = _ref.className;
    return jsx("a", _extends({
      "data-testid": testId
    }, rest, {
      className: className,
      href: isDisabled ? undefined : href,
      draggable: false,
      onDragStart: preventEvent,
      onMouseDown: isDisabled ? preventEvent : onMouseDownHandler,
      onClick: isDisabled ? preventEvent : onClick,
      "aria-current": isSelected ? 'page' : undefined,
      "aria-disabled": isDisabled,
      ref: ref
    }), children);
  });
}));
export default LinkItem;