<!-- API Report Version: 2.3 -->

## API Report File for "@atlaskit/menu"

> Do not edit this file. This report is auto-generated using [API Extractor](https://api-extractor.com/).
> [Learn more about API reports](https://hello.atlassian.net/wiki/spaces/UR/pages/1825484529/Package+API+Reports)

### Table of contents

- [Main Entry Types](#main-entry-types)
- [Peer Dependencies](#peer-dependencies)

### Main Entry Types

<!--SECTION START: Main Entry Types-->

```ts
/// <reference types="react" />

import { ComponentType } from 'react';
import { Context } from 'react';
import { CSSObject } from '@emotion/react';
import { ForwardRefExoticComponent } from 'react';
import { jsx } from '@emotion/react';
import { MemoExoticComponent } from 'react';
import { ReactNode } from 'react';
import { Ref } from 'react';
import { RefAttributes } from 'react';

// @public (undocumented)
export interface BaseItemProps {
  children?: React.ReactNode;
  // @deprecated
  cssFn?: CSSFn;
  description?: JSX.Element | string;
  iconAfter?: React.ReactNode;
  iconBefore?: React.ReactNode;
  isDisabled?: boolean;
  isSelected?: boolean;
  onClick?: (event: React.KeyboardEvent | React.MouseEvent) => void;
  onMouseDown?: React.MouseEventHandler;
  // @deprecated
  overrides?: Overrides;
  shouldDescriptionWrap?: boolean;
  shouldTitleWrap?: boolean;
  testId?: string;
}

// @public
export const ButtonItem: MemoExoticComponent<
  ForwardRefExoticComponent<ButtonItemProps & RefAttributes<HTMLElement>>
>;

// @public (undocumented)
export interface ButtonItemProps extends BaseItemProps {
  id?: string;
  role?: string;
}

// @public @deprecated
export interface CSSFn<TState = ItemState extends void ? void : ItemState> {
  // (undocumented)
  (currentState: TState): CSSObject | CSSObject[];
}

// @public
export const CustomItem: CustomItemTypeGenericHackProps;

// @public (undocumented)
export interface CustomItemComponentProps {
  'data-testid'?: string;
  children: React.ReactNode;
  className: string;
  disabled?: boolean;
  draggable: boolean;
  onClick?: (event: React.MouseEvent<HTMLElement>) => void;
  onDragStart?: (event: React.DragEvent) => void;
  onMouseDown?: (event: React.MouseEvent<HTMLElement>) => void;
  ref?: Ref<any>;
  tabIndex?: number;
}

// @public (undocumented)
export interface CustomItemProps<
  TCustomComponentProps = CustomItemComponentProps,
> extends BaseItemProps {
  component?: React.ComponentType<TCustomComponentProps>;
}

// @public (undocumented)
interface CustomItemTypeGenericHackProps {
  // (undocumented)
  <TComponentProps>(
    props: CustomItemProps<TComponentProps> & {
      ref?: any;
    } & Omit<TComponentProps, keyof CustomItemComponentProps>,
  ): JSX.Element | null;
}

// @public (undocumented)
export type Dimension = number | string;

// @public
export const HeadingItem: MemoExoticComponent<
  ({
    children,
    testId,
    id,
    cssFn,
    ...rest
  }: HeadingItemProps) => jsx.JSX.Element
>;

// @public (undocumented)
export interface HeadingItemProps {
  children: React.ReactNode;
  // @deprecated
  cssFn?: StatelessCSSFn;
  id?: string;
  testId?: string;
}

// @public (undocumented)
export type ItemState = {
  isSelected: boolean;
  isDisabled: boolean;
};

// @public
export const LinkItem: MemoExoticComponent<
  ForwardRefExoticComponent<LinkItemProps & RefAttributes<HTMLElement>>
>;

// @public (undocumented)
export interface LinkItemProps extends BaseItemProps {
  href?: string;
  rel?: string;
  role?: string;
  target?: string;
}

// @public
export const MenuGroup: ({
  maxWidth,
  minWidth,
  minHeight,
  maxHeight,
  testId,
  role,
  spacing,
  ...rest
}: MenuGroupProps) => jsx.JSX.Element;

// @public (undocumented)
export interface MenuGroupProps extends MenuGroupSizing {
  children: React.ReactNode;
  onClick?: (event: React.KeyboardEvent | React.MouseEvent) => void;
  role?: string;
  spacing?: SpacingMode;
  testId?: string;
}

// @public (undocumented)
export interface MenuGroupSizing {
  maxHeight?: Dimension;
  maxWidth?: Dimension;
  minHeight?: Dimension;
  minWidth?: Dimension;
}

// @public @deprecated (undocumented)
export interface Overrides {
  // (undocumented)
  Title?: TitleOverrides;
}

// @public @deprecated (undocumented)
export const PopupMenuGroup: ({
  maxWidth,
  minWidth,
  ...rest
}: MenuGroupProps) => jsx.JSX.Element;

// @public (undocumented)
export interface RenderFunction<TProps = {}> {
  // (undocumented)
  (Component: ComponentType | string, props: TProps): React.ReactNode;
}

// @public
export const Section: ForwardRefExoticComponent<
  SectionProps & RefAttributes<HTMLElement>
>;

// @public (undocumented)
interface SectionProps {
  children: React.ReactNode;
  hasSeparator?: boolean;
  id?: string;
  isList?: boolean;
  isScrollable?: boolean;
  // @deprecated (undocumented)
  overrides?: {
    HeadingItem?: {
      cssFn?: StatelessCSSFn;
    };
  };
  testId?: string;
  title?: string;
}
export { SectionProps as SectionBaseProps };
export { SectionProps };

// @internal
export const SELECTION_STYLE_CONTEXT_DO_NOT_USE: Context<
  'border' | 'none' | 'notch'
>;

// @public
export const SkeletonHeadingItem: ({
  isShimmering,
  testId,
  width,
  cssFn,
}: SkeletonHeadingItemProps) => jsx.JSX.Element;

// @public (undocumented)
export interface SkeletonHeadingItemProps {
  // @deprecated
  cssFn?: StatelessCSSFn;
  isShimmering?: boolean;
  testId?: string;
  width?: Dimension;
}

// @public
export const SkeletonItem: ({
  hasAvatar,
  hasIcon,
  isShimmering,
  testId,
  width,
  cssFn,
}: SkeletonItemProps) => jsx.JSX.Element;

// @public (undocumented)
export interface SkeletonItemProps {
  cssFn?: StatelessCSSFn;
  hasAvatar?: boolean;
  hasIcon?: boolean;
  isShimmering?: boolean;
  testId?: string;
  width?: Dimension;
}

// @internal
export const SpacingContext: Context<SpacingMode>;

// @public (undocumented)
type SpacingMode = 'compact' | 'cozy';

// @public @deprecated (undocumented)
export type StatelessCSSFn = CSSFn<void>;

// @public @deprecated (undocumented)
export interface TitleOverrides {
  // (undocumented)
  render?: RenderFunction<{
    className?: string;
    children: ReactNode;
    'data-item-title': boolean;
  }>;
}

// (No @packageDocumentation comment for this package)
```

<!--SECTION END: Main Entry Types-->

### Peer Dependencies

<!--SECTION START: Peer Dependencies-->

```json
{
  "react": "^16.8.0",
  "react-dom": "^16.8.0"
}
```

<!--SECTION END: Peer Dependencies-->
