"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
var _deprecationWarning = require("@atlaskit/ds-lib/deprecation-warning");
var _focusRing = _interopRequireDefault(require("@atlaskit/focus-ring"));
var _platformFeatureFlags = require("@atlaskit/platform-feature-flags");
var _inline = _interopRequireDefault(require("@atlaskit/primitives/inline"));
var _colors = require("@atlaskit/theme/colors");
var _menuContext = require("./menu-context");
/** @jsx jsx */

var defaultRender = function defaultRender(Component, props) {
  return (
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
    (0, _react2.jsx)(Component, props)
  );
};
var beforeAfterElementStyles = (0, _react2.css)({
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  flexShrink: 0
});
var contentStyles = (0, _react2.css)({
  display: 'flex',
  justifyContent: 'center',
  flexDirection: 'column',
  flexGrow: 1,
  // Fix - avoid clipped text descenders when using standard 16px line-height
  lineHeight: "var(--ds-font-lineHeight-100, 16px)",
  outline: 'none',
  overflow: 'hidden',
  textAlign: 'left'
});
var truncateStyles = (0, _react2.css)({
  display: 'block',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
  whiteSpace: 'nowrap'
});
var wordBreakStyles = (0, _react2.css)({
  wordBreak: 'break-word'
});
var descriptionStyles = (0, _react2.css)({
  marginTop: "var(--ds-space-050, 4px)",
  color: "var(--ds-text-subtlest, ".concat(_colors.N200, ")"),
  fontSize: "var(--ds-font-size-075, 12px)"
});
var disabledDescriptionStyles = (0, _react2.css)({
  color: "var(--ds-text-disabled, ".concat(_colors.N200, ")")
});
var positionRelativeStyles = (0, _react2.css)({
  position: 'relative'
});
var primitiveStyles = (0, _react2.css)({
  display: 'flex',
  boxSizing: 'border-box',
  width: '100%',
  minHeight: 40,
  margin: "var(--ds-space-0, 0px)",
  alignItems: 'center',
  border: 0,
  fontSize: "var(--ds-font-size-100, 14px)",
  outline: 0,
  textDecoration: 'none',
  userSelect: 'none',
  '::-moz-focus-inner': {
    border: 0
  },
  ':hover': {
    textDecoration: 'none'
  }
});
var spacingMapStyles = {
  cozy: (0, _react2.css)({
    // 8 * 2 (16) + icon (24) === 40
    paddingBlock: "var(--ds-space-100, 8px)",
    paddingInline: "var(--ds-space-200, 16px)"
  }),
  compact: (0, _react2.css)({
    minHeight: 32,
    // 4 * 2 (8) + icon (24) === 32
    paddingBlock: "var(--ds-space-050, 4px)",
    paddingInline: "var(--ds-space-150, 12px)"
  })
};
var interactiveStyles = (0, _react2.css)({
  cursor: 'pointer'
});
var unselectedStyles = (0, _react2.css)({
  backgroundColor: "var(--ds-background-neutral-subtle, transparent)",
  color: 'currentColor',
  ':visited': {
    color: 'currentColor'
  },
  ':hover': {
    backgroundColor: "var(--ds-background-neutral-subtle-hovered, ".concat(_colors.N20, ")"),
    color: 'currentColor'
  },
  ':active': {
    backgroundColor: "var(--ds-background-neutral-subtle-pressed, ".concat(_colors.N30, ")"),
    boxShadow: 'none',
    color: 'currentColor'
  }
});
var disabledStyles = (0, _react2.css)({
  cursor: 'not-allowed',
  '&, :hover, :active': {
    backgroundColor: "var(--ds-background-neutral-subtle, transparent)",
    color: "var(--ds-text-disabled, ".concat(_colors.N200, ")")
  }
});
var selectedBorderStyles = (0, _react2.css)({
  '&::before': {
    width: 2,
    position: 'absolute',
    top: 0,
    bottom: 0,
    left: 0,
    background: "var(--ds-border-selected, transparent)",
    content: '""'
  }
});
var selectedNotchStyles = (0, _react2.css)({
  '&::before': {
    width: 4,
    position: 'absolute',
    top: "var(--ds-space-150, 12px)",
    bottom: "var(--ds-space-150, 12px)",
    left: 0,
    background: "var(--ds-border-selected, transparent)",
    borderRadius: "0 ".concat("var(--ds-border-radius, 4px)", " ", "var(--ds-border-radius, 4px)", " 0"),
    content: '""'
  }
});
var selectedStyles = (0, _react2.css)({
  backgroundColor: "var(--ds-background-selected, ".concat(_colors.N20, ")"),
  // Fallback set as babel plugin inserts one otherwise
  color: "var(--ds-text-selected, currentColor)",
  ':visited': {
    color: "var(--ds-text-selected, currentColor)"
  },
  ':hover': {
    backgroundColor: "var(--ds-background-selected-hovered, ".concat(_colors.N20, ")"),
    color: "var(--ds-text-selected, currentColor)"
  },
  ':active': {
    backgroundColor: "var(--ds-background-selected-pressed, ".concat(_colors.N30, ")"),
    color: "var(--ds-text-selected, currentColor)"
  }
});
var gapMap = {
  compact: 'space.100',
  cozy: 'space.150'
};

/**
 * __Menu item primitive__
 *
 * Menu item primitive contains all the styles for menu items,
 * including support for selected, disabled, and interaction states.
 *
 * Using children as function prop you wire up this to your own host element.
 *
 * ```jsx
 * <MenuItemPrimitive>
 *   {({ children, ...props }) => <button {...props}>{children}</button>}
 * </MenuItemPrimitive>
 * ```
 */
var MenuItemPrimitive = function MenuItemPrimitive(_ref) {
  var children = _ref.children,
    title = _ref.title,
    description = _ref.description,
    iconAfter = _ref.iconAfter,
    iconBefore = _ref.iconBefore,
    overrides = _ref.overrides,
    className = _ref.className,
    _ref$shouldTitleWrap = _ref.shouldTitleWrap,
    shouldTitleWrap = _ref$shouldTitleWrap === void 0 ? false : _ref$shouldTitleWrap,
    _ref$shouldDescriptio = _ref.shouldDescriptionWrap,
    shouldDescriptionWrap = _ref$shouldDescriptio === void 0 ? false : _ref$shouldDescriptio,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected;
  (0, _deprecationWarning.propDeprecationWarning)("@atlaskit/menu", 'overrides', overrides !== undefined, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  var spacing = (0, _react.useContext)(_menuContext.SpacingContext);
  var selectionStyle = (0, _react.useContext)(_menuContext.SELECTION_STYLE_CONTEXT_DO_NOT_USE);
  var renderTitle = overrides && overrides.Title && overrides.Title.render || defaultRender;
  return (0, _react2.jsx)(_react2.ClassNames, null, function (_ref2) {
    var cn = _ref2.css,
      cx = _ref2.cx;
    return (0, _react2.jsx)(_focusRing.default, {
      isInset: true
    }, children({
      className: cx([cn([(0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.menu-selected-state-change_0see9') && positionRelativeStyles, primitiveStyles, spacingMapStyles[spacing], !isDisabled && !isSelected && unselectedStyles, !isDisabled && isSelected && [selectedStyles, (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.menu-selected-state-change_0see9') && [selectionStyle === 'border' && selectedBorderStyles, selectionStyle === 'notch' && selectedNotchStyles]], isDisabled ? disabledStyles : interactiveStyles]), className]),
      children: (0, _react2.jsx)(_inline.default, {
        as: "span",
        spread: "space-between",
        alignBlock: "center",
        space: gapMap[spacing],
        grow: "fill"
      }, iconBefore && (0, _react2.jsx)("span", {
        "data-item-elem-before": true,
        css: beforeAfterElementStyles
      }, iconBefore), title && (0, _react2.jsx)("span", {
        css: contentStyles
      }, renderTitle('span', {
        children: title,
        className: cn(shouldTitleWrap ? wordBreakStyles : truncateStyles),
        'data-item-title': true
      }), description && (0, _react2.jsx)("span", {
        "data-item-description": true,
        css: [descriptionStyles, isDisabled && disabledDescriptionStyles, shouldDescriptionWrap ? wordBreakStyles : truncateStyles]
      }, description)), iconAfter && (0, _react2.jsx)("span", {
        "data-item-elem-after": true,
        css: beforeAfterElementStyles
      }, iconAfter))
    }));
  });
};
var _default = MenuItemPrimitive;
exports.default = _default;