"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("@emotion/react");
var _deprecationWarning = require("@atlaskit/ds-lib/deprecation-warning");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _colors = require("@atlaskit/theme/colors");
var _skeletonShimmer = _interopRequireDefault(require("../internal/components/skeleton-shimmer"));
/** @jsx jsx */

var skeletonStyles = (0, _react.css)({
  paddingBlock: "var(--ds-space-0, 0px)",
  paddingInline: "var(--ds-space-200, 16px)",
  '::after': {
    display: 'block',
    width: '30%',
    height: "var(--ds-space-100, 8px)",
    backgroundColor: "var(--ds-skeleton, ".concat(_colors.N20A, ")"),
    borderRadius: 100,
    content: '""'
  }
});
var defaultWidthStyles = (0, _react.css)({
  '::after': {
    width: '30%'
  }
});
var customWidthStyles = (0, _react.css)({
  '::after': {
    width: 'var(--width)'
  }
});

/**
 * __Skeleton heading item__
 *
 * A skeleton heading item is used in place of a heading item when its contents it not ready.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/skeleton-heading-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var SkeletonHeadingItem = function SkeletonHeadingItem(_ref) {
  var _ref$isShimmering = _ref.isShimmering,
    isShimmering = _ref$isShimmering === void 0 ? false : _ref$isShimmering,
    testId = _ref.testId,
    width = _ref.width,
    _ref$cssFn = _ref.cssFn,
    cssFn = _ref$cssFn === void 0 ? _noop.default : _ref$cssFn;
  (0, _deprecationWarning.propDeprecationWarning)("@atlaskit/menu", 'cssFn', cssFn !== _noop.default, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return (0, _react.jsx)(_skeletonShimmer.default, {
    isShimmering: isShimmering
  }, function (_ref2) {
    var className = _ref2.className;
    return (0, _react.jsx)("div", {
      className: className,
      style: {
        '--width': width
      },
      css: [skeletonStyles, width ? customWidthStyles : defaultWidthStyles,
      // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
      (0, _react.css)(cssFn(undefined))],
      "data-ds--menu--skeleton-heading-item": true,
      "data-testid": testId
    });
  });
};
var _default = SkeletonHeadingItem;
exports.default = _default;