"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("@emotion/react");
var _dsExplorations = require("@atlaskit/ds-explorations");
var _menuContext = require("../internal/components/menu-context");
var _excluded = ["maxWidth", "minWidth", "minHeight", "maxHeight", "testId", "role", "spacing"];
/** @jsx jsx */
/**
 * __Menu group__
 *
 * A menu group includes all the actions or items in a menu.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/menu-group)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var MenuGroup = function MenuGroup(_ref) {
  var maxWidth = _ref.maxWidth,
    minWidth = _ref.minWidth,
    minHeight = _ref.minHeight,
    maxHeight = _ref.maxHeight,
    testId = _ref.testId,
    role = _ref.role,
    _ref$spacing = _ref.spacing,
    spacing = _ref$spacing === void 0 ? 'cozy' : _ref$spacing,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return (0, _react.jsx)(_menuContext.SpacingContext.Provider, {
    value: spacing
  }, (0, _react.jsx)(_menuContext.SELECTION_STYLE_CONTEXT_DO_NOT_USE.Provider, {
    value: "border"
  }, (0, _react.jsx)(_dsExplorations.UNSAFE_Box, (0, _extends2.default)({
    UNSAFE_style: {
      minWidth: minWidth,
      maxWidth: maxWidth,
      minHeight: minHeight,
      maxHeight: maxHeight
    },
    display: "flex",
    flexDirection: "column",
    overflow: "auto",
    testId: testId,
    role: role,
    position: "static"
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  }, rest))));
};
var _default = MenuGroup;
exports.default = _default;