import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */
import { forwardRef, memo } from 'react';
import { jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import noop from '@atlaskit/ds-lib/noop';
import MenuItemPrimitive from '../internal/components/menu-item-primitive';
/**
 * __Button item__
 *
 * A button item is used to populate a menu with items that are buttons.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/button-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
const ButtonItem = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(
// Type needed on props to extract types with extract react types.
(props, ref) => {
  const {
    children,
    cssFn = noop,
    description,
    iconAfter,
    iconBefore,
    isDisabled = false,
    isSelected = false,
    onClick,
    testId,
    overrides,
    onMouseDown,
    shouldTitleWrap,
    shouldDescriptionWrap,
    ...rest
  } = props;
  const onMouseDownHandler = onMouseDown;
  if (!children) {
    return null;
  }
  propDeprecationWarning("@atlaskit/menu", 'cssFn', cssFn !== noop, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  return jsx(MenuItemPrimitive, _extends({}, rest, {
    // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
    overrides: overrides,
    iconBefore: iconBefore,
    iconAfter: iconAfter,
    isDisabled: isDisabled,
    isSelected: isSelected,
    description: description,
    title: children,
    shouldTitleWrap: shouldTitleWrap,
    shouldDescriptionWrap: shouldDescriptionWrap,
    css:
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    cssFn({
      isSelected,
      isDisabled
    })
  }), ({
    children,
    className
  }) => jsx("button", _extends({
    "data-testid": testId
  }, rest, {
    className: className,
    ref: ref,
    disabled: isDisabled,
    onClick: onClick,
    onMouseDown: onMouseDownHandler,
    type: "button"
  }), children));
}));
export default ButtonItem;