import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["maxWidth", "minWidth", "minHeight", "maxHeight", "testId", "role", "spacing"];
/** @jsx jsx */
import { jsx } from '@emotion/react';
import { UNSAFE_Box as Box } from '@atlaskit/ds-explorations';
import { SELECTION_STYLE_CONTEXT_DO_NOT_USE, SpacingContext } from '../internal/components/menu-context';
/**
 * __Menu group__
 *
 * A menu group includes all the actions or items in a menu.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/menu-group)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var MenuGroup = function MenuGroup(_ref) {
  var maxWidth = _ref.maxWidth,
    minWidth = _ref.minWidth,
    minHeight = _ref.minHeight,
    maxHeight = _ref.maxHeight,
    testId = _ref.testId,
    role = _ref.role,
    _ref$spacing = _ref.spacing,
    spacing = _ref$spacing === void 0 ? 'cozy' : _ref$spacing,
    rest = _objectWithoutProperties(_ref, _excluded);
  return jsx(SpacingContext.Provider, {
    value: spacing
  }, jsx(SELECTION_STYLE_CONTEXT_DO_NOT_USE.Provider, {
    value: "border"
  }, jsx(Box, _extends({
    UNSAFE_style: {
      minWidth: minWidth,
      maxWidth: maxWidth,
      minHeight: minHeight,
      maxHeight: maxHeight
    },
    display: "flex",
    flexDirection: "column",
    overflow: "auto",
    testId: testId,
    role: role,
    position: "static"
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  }, rest))));
};
export default MenuGroup;