import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "overrides", "title", "testId", "isScrollable", "hasSeparator", "id", "isList"];
/* eslint-disable @atlaskit/design-system/ensure-design-token-usage, @atlaskit/design-system/ensure-design-token-usage/preview */
/** @jsx jsx */
import { Children, forwardRef, Fragment } from 'react';
import { css, jsx } from '@emotion/react';
import { propDeprecationWarning } from '@atlaskit/ds-lib/deprecation-warning';
import { N30A } from '@atlaskit/theme/colors';
// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
import { gridSize as gridSizeFn } from '@atlaskit/theme/constants';
import { headingSizes } from '@atlaskit/theme/typography';
import HeadingItem from '../menu-item/heading-item';
var gridSize = gridSizeFn();
var itemHeadingTopMargin = gridSize * 2.5;
var itemHeadingBottomMargin = gridSize * 0.75;
// Skeleton content is slightly shorter than the real content.
// Because of that we slightly increase the top margin to offset this so the
// containing size both real and skeleton always equal approx 30px.
var itemHeadingContentHeight = headingSizes.h100.lineHeight;
var skeletonHeadingHeight = gridSize;
var skeletonHeadingMarginOffset = 3;
var skeletonHeadingTopMargin = itemHeadingTopMargin + (itemHeadingContentHeight - skeletonHeadingHeight) - skeletonHeadingMarginOffset;
// We want to move the entire body up by 3px without affecting the height of the skeleton container.
var skeletonHeadingBottomMargin = itemHeadingBottomMargin + skeletonHeadingMarginOffset;
var sectionPaddingTopBottom = gridSize * 0.75;
var VAR_SEPARATOR_COLOR = '--ds-menu-seperator-color';
var sectionStyles = css({
  '&::before, &::after': {
    display: 'block',
    height: sectionPaddingTopBottom,
    content: '""'
  },
  // eslint-disable-next-line @atlaskit/design-system/no-nested-styles
  '& [data-ds--menu--heading-item]': {
    marginTop: itemHeadingTopMargin,
    marginBottom: itemHeadingBottomMargin,
    '&:first-of-type': {
      marginTop: itemHeadingTopMargin - sectionPaddingTopBottom
    }
  },
  // eslint-disable-next-line @atlaskit/design-system/no-nested-styles
  '& [data-ds--menu--skeleton-heading-item]': {
    marginTop: skeletonHeadingTopMargin,
    marginBottom: skeletonHeadingBottomMargin,
    '&:first-of-type': {
      marginTop: skeletonHeadingTopMargin - sectionPaddingTopBottom
    }
  },
  '&:focus': {
    // NOTE: Firefox allows elements that have "overflow: auto" to gain focus (as if it had tab-index="0")
    // We have made a deliberate choice to leave this behaviour as is.
    // This makes the outline go inside by 1px so it can actually be displayed
    // else it gets cut off from the overflow: scroll from the parent menu group.
    outlineOffset: -1
  }
});
var scrollableStyles = css({
  flexShrink: 1,
  overflow: 'auto'
});
var unscrollableStyles = css({
  flexShrink: 0
});
var separatorStyles = css({
  borderTop: "2px solid var(".concat(VAR_SEPARATOR_COLOR, ", ", "var(--ds-border, ".concat(N30A, ")"), ")")
});
var noSeparatorStyles = css({
  // this is to ensure that adjacent sections without separators don't get additional margins.
  // eslint-disable-next-line @atlaskit/design-system/no-nested-styles
  '[data-section] + &': {
    marginTop: -6
  }
});

/**
 * __Section__
 *
 * A section includes related actions or items in a menu.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/section)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
var Section = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var children = _ref.children,
    overrides = _ref.overrides,
    title = _ref.title,
    testId = _ref.testId,
    isScrollable = _ref.isScrollable,
    hasSeparator = _ref.hasSeparator,
    id = _ref.id,
    _ref$isList = _ref.isList,
    isList = _ref$isList === void 0 ? false : _ref$isList,
    rest = _objectWithoutProperties(_ref, _excluded);
  propDeprecationWarning("@atlaskit/menu", 'overrides', overrides !== undefined, '' // TODO: Create DAC post when primitives/xcss are available as alternatives
  );

  var content = isList ? jsx("ul", {
    style: {
      margin: 0,
      padding: 0
    }
  }, Children.map(Children.toArray(children), function (child, index) {
    return jsx("li", {
      style: {
        listStyleType: 'none',
        margin: 0,
        padding: 0
      },
      key: index
    }, child);
  })) : children;
  var childrenMarkup = title !== undefined ? jsx(Fragment, null, jsx(HeadingItem
  // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
  , {
    cssFn: overrides && overrides.HeadingItem && overrides.HeadingItem.cssFn,
    testId: testId && "".concat(testId, "--heading"),
    "aria-hidden": true
  }, title), content) : jsx(Fragment, null, content);
  return jsx("div", _extends({}, rest, {
    id: id
    // NOTE: Firefox allows elements that have "overflow: auto" to gain focus (as if it had tab-index="0")
    // We have made a deliberate choice to leave this behaviour as is.
    ,
    css: [sectionStyles, isScrollable ? scrollableStyles : unscrollableStyles, hasSeparator ? separatorStyles : noSeparatorStyles],
    "aria-label": title,
    "data-testid": testId,
    role: "group",
    "data-section": true,
    ref: ref
  }), childrenMarkup);
});
export default Section;