/// <reference types="react" />
/** @jsx jsx */
import type { CustomItemComponentProps, CustomItemProps } from '../types';
interface CustomItemTypeGenericHackProps {
    <TComponentProps>(props: CustomItemProps<TComponentProps> & {
        ref?: any;
    } & Omit<TComponentProps, keyof CustomItemComponentProps>): JSX.Element | null;
}
/**
 * __Custom item__
 *
 * A custom item is used to populate a menu with items that can be any element.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/menu/docs/custom-item)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/menu)
 */
declare const CustomItem: CustomItemTypeGenericHackProps;
export default CustomItem;
