"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useModal = void 0;
var _react = require("react");
var _context = require("./internal/context");
var useModal = function useModal() {
  var modalContext = (0, _react.useContext)(_context.ModalContext);
  if (modalContext == null) {
    throw Error('@atlaskit/modal-dialog: Modal context unavailable – this component needs to be a child of ModalDialog.');
  }
  return modalContext;
};
exports.useModal = useModal;