"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("@emotion/react");
var _curves = require("@atlaskit/motion/curves");
var _durations = require("@atlaskit/motion/durations");
var _constants = require("@atlaskit/theme/constants");
var _constants2 = require("../constants");
/* eslint-disable @atlaskit/design-system/ensure-design-token-usage-spacing */
/** @jsx jsx */

var maxWidthDimensions = "calc(100vw - ".concat(_constants2.gutter * 2, "px)");
var maxHeightDimensions = "calc(100vh - ".concat(_constants2.gutter * 2 - 1, "px)");

// Flex and min-content are set to constrain the height of the body and support multi-column scrolling experiences
var positionerStyles = (0, _react.css)({
  display: 'flex',
  width: '100%',
  maxWidth: '100%',
  height: '100%',
  position: 'fixed',
  zIndex: _constants.layers.modal(),
  top: 0,
  left: 0,
  flexDirection: 'column'
});
var viewportScrollStyles = (0, _react.css)({
  height: 'auto',
  position: 'relative',
  '@media (min-width: 480px)': {
    margin: "".concat(_constants2.gutter, "px auto"),
    pointerEvents: 'none'
  }
});
var bodyScrollStyles = (0, _react.css)({
  '@media (min-width: 480px)': {
    maxWidth: maxWidthDimensions,
    maxHeight: maxHeightDimensions,
    marginRight: 'auto',
    marginLeft: 'auto',
    position: 'absolute',
    top: "".concat(_constants2.gutter, "px"),
    right: 0,
    left: 0,
    pointerEvents: 'none'
  }
});
var stackTransitionStyles = (0, _react.css)({
  transitionDuration: "".concat(_durations.mediumDurationMs, "ms"),
  transitionProperty: 'transform',
  transitionTimingFunction: _curves.easeInOut,
  /**
   * Duplicated from @atlaskit/motion/accessibility
   * because @repo/internal/styles/consistent-style-ordering
   * doesn't work well with object spreading.
   */
  '@media (prefers-reduced-motion: reduce)': {
    animation: 'none',
    transition: 'none'
  }
});
var stackTransformStyles = (0, _react.css)({
  transform: 'translateY(var(--modal-dialog-translate-y))'
});
var stackIdleStyles = (0, _react.css)({
  transform: 'none'
});
var Positioner = function Positioner(props) {
  var children = props.children,
    stackIndex = props.stackIndex,
    shouldScrollInViewport = props.shouldScrollInViewport,
    testId = props.testId;
  return (0, _react.jsx)("div", {
    style: {
      '--modal-dialog-translate-y': "".concat(stackIndex * (_constants2.verticalOffset / 2), "px")
    },
    css: [positionerStyles, stackTransitionStyles, /* We only want to apply transform on modals shifting to the back of the stack. */
    stackIndex > 0 ? stackTransformStyles : stackIdleStyles, shouldScrollInViewport ? viewportScrollStyles : bodyScrollStyles],
    "data-testid": testId && "".concat(testId, "--positioner")
  }, children);
};

// eslint-disable-next-line @repo/internal/react/require-jsdoc
var _default = Positioner;
exports.default = _default;