"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.width = exports.verticalOffset = exports.titleIconMargin = exports.textColor = exports.padding = exports.keylineHeight = exports.keylineColor = exports.iconColor = exports.gutter = exports.borderRadius = void 0;
var _colors = require("@atlaskit/theme/colors");
var _constants = require("@atlaskit/theme/constants");
var width = {
  values: ['small', 'medium', 'large', 'x-large'],
  widths: {
    small: 400,
    medium: 600,
    large: 800,
    'x-large': 968
  },
  defaultValue: 'medium'
};
exports.width = width;
var gutter = 60;
exports.gutter = gutter;
var gridSize = (0, _constants.gridSize)();
var borderRadius = (0, _constants.borderRadius)();
exports.borderRadius = borderRadius;
var verticalOffset = gridSize * 2;
exports.verticalOffset = verticalOffset;
var padding = gridSize * 3;
exports.padding = padding;
var titleIconMargin = gridSize;
exports.titleIconMargin = titleIconMargin;
var keylineHeight = 2;
exports.keylineHeight = keylineHeight;
var keylineColor = "var(--ds-border, ".concat(_colors.N30, ")");
exports.keylineColor = keylineColor;
var textColor = "var(--ds-text, ".concat(_colors.N900, ")");
exports.textColor = textColor;
var iconColor = {
  danger: "var(--ds-icon-danger, ".concat(_colors.R400, ")"),
  warning: "var(--ds-icon-warning, ".concat(_colors.Y400, ")")
};
exports.iconColor = iconColor;