"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useOnMotionFinish;
var _react = require("react");
// eslint-disable-next-line @repo/internal/react/require-jsdoc
function useOnMotionFinish(_ref) {
  var onOpenComplete = _ref.onOpenComplete,
    onCloseComplete = _ref.onCloseComplete;
  var motionRef = (0, _react.useRef)(null);
  var onMotionFinish = (0, _react.useCallback)(function (state) {
    if (state === 'entering' && onOpenComplete) {
      onOpenComplete(motionRef.current, true);
    }
    if (state === 'exiting' && onCloseComplete) {
      onCloseComplete(motionRef.current);
    }
  }, [onOpenComplete, onCloseComplete]);
  return [motionRef, onMotionFinish];
}