"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _reactScrolllock = require("react-scrolllock");
var _hooks = require("./hooks");
var _scrollContainer = _interopRequireDefault(require("./internal/components/scroll-container"));
var _constants = require("./internal/constants");
var _useScroll = _interopRequireDefault(require("./internal/hooks/use-scroll"));
/** @jsx jsx */

var bodyStyles = (0, _react2.css)({
  /* This ensures the body fills the whole space between header and footer. */
  flex: '1 1 auto'
});

/**
 * Adding the padding here avoids cropping the keyline on its sides.
 * The combined vertical spacing is maintained by subtracting the
 * keyline height from header and footer.
 */
var bodyScrollStyles = (0, _react2.css)({
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage-spacing
  padding: "".concat(_constants.keylineHeight, "px ").concat(_constants.padding, "px")
});

/**
 * Keylines will not be shown if scrolling in viewport so we do
 * not account for them in this case.
 */
var viewportScrollStyles = (0, _react2.css)({
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage-spacing
  padding: "0px ".concat(_constants.padding, "px")
});
/**
 * __Modal body__
 *
 * A modal body is used to display the main content of a modal.
 *
 * - [Examples](https://atlassian.design/components/modal-dialog/examples)
 * - [Code](https://atlassian.design/components/modal-dialog/code#modal-body-props)
 * - [Usage](https://atlassian.design/components/modal-dialog/usage)
 */
var ModalBody = function ModalBody(props) {
  var children = props.children,
    userDefinedTestId = props.testId;
  var _useModal = (0, _hooks.useModal)(),
    modalTestId = _useModal.testId;
  var shouldScrollInViewport = (0, _useScroll.default)();
  var testId = userDefinedTestId || modalTestId && "".concat(modalTestId, "--body");
  return shouldScrollInViewport ? (0, _react2.jsx)("div", {
    css: [bodyStyles, viewportScrollStyles],
    "data-testid": testId
  }, children) : (0, _react2.jsx)(_reactScrolllock.TouchScrollable, null, (0, _react2.jsx)(_scrollContainer.default, {
    testId: userDefinedTestId || modalTestId
  }, (0, _react2.jsx)("div", {
    css: [bodyStyles, bodyScrollStyles],
    "data-testid": testId
  }, children)));
};
var _default = ModalBody;
exports.default = _default;