import { N30, N900, R400, Y400 } from '@atlaskit/theme/colors';
import { borderRadius as getBorderRadius,
// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
gridSize as getGridSize } from '@atlaskit/theme/constants';
export const width = {
  values: ['small', 'medium', 'large', 'x-large'],
  widths: {
    small: 400,
    medium: 600,
    large: 800,
    'x-large': 968
  },
  defaultValue: 'medium'
};
export const gutter = 60;
const gridSize = getGridSize();
export const borderRadius = getBorderRadius();
export const verticalOffset = gridSize * 2;
export const padding = gridSize * 3;
export const titleIconMargin = gridSize;
export const keylineHeight = 2;
export const keylineColor = `var(--ds-border, ${N30})`;
export const textColor = `var(--ds-text, ${N900})`;
export const iconColor = {
  danger: `var(--ds-icon-danger, ${R400})`,
  warning: `var(--ds-icon-warning, ${Y400})`
};