import { useCallback, useRef } from 'react';
// eslint-disable-next-line @repo/internal/react/require-jsdoc
export default function useOnMotionFinish({
  onOpenComplete,
  onCloseComplete
}) {
  const motionRef = useRef(null);
  const onMotionFinish = useCallback(state => {
    if (state === 'entering' && onOpenComplete) {
      onOpenComplete(motionRef.current, true);
    }
    if (state === 'exiting' && onCloseComplete) {
      onCloseComplete(motionRef.current);
    }
  }, [onOpenComplete, onCloseComplete]);
  return [motionRef, onMotionFinish];
}