/** @jsx jsx */

import { css, jsx } from '@emotion/react';
import { useModal } from './hooks';
import { keylineHeight, padding } from './internal/constants';
const footerStyles = css({
  display: 'flex',
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage-spacing
  padding,
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage-spacing
  paddingTop: `${padding - keylineHeight}px`,
  position: 'relative',
  alignItems: 'center',
  justifyContent: 'flex-end',
  gap: "var(--ds-space-100, 8px)"
});
/**
 * __Modal footer__
 *
 * A modal footer often contains a primary action and the ability to cancel and close the dialog, though can contain any React element.
 *
 * - [Examples](https://atlassian.design/components/modal-dialog/examples#modal-footer)
 * - [Code](https://atlassian.design/components/modal-dialog/code#modal-footer-props)
 * - [Usage](https://atlassian.design/components/modal-dialog/usage)
 */
const ModalFooter = props => {
  const {
    children,
    testId: userDefinedTestId
  } = props;
  const {
    testId: modalTestId
  } = useModal();
  const testId = userDefinedTestId || modalTestId && `${modalTestId}--footer`;
  return jsx("div", {
    css: footerStyles,
    "data-testid": testId
  }, children);
};
export default ModalFooter;