/** @jsx jsx */
import React from 'react';
import { css, jsx } from '@emotion/react';
import { useModal } from './hooks';
import { keylineHeight, padding } from './internal/constants';
const headerStyles = css({
  display: 'flex',
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage-spacing
  padding: padding,
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage-spacing
  paddingBottom: `${padding - keylineHeight}px`,
  position: 'relative',
  alignItems: 'center',
  justifyContent: 'space-between'
});
/**
 * __Modal header__
 *
 * A modal header contains the title of the modal and can contain other React elements such as a close button.
 *
 * - [Examples](https://atlassian.design/components/modal-dialog/examples#modal-header)
 * - [Code](https://atlassian.design/components/modal-dialog/code#modal-header-props)
 * - [Usage](https://atlassian.design/components/modal-dialog/usage)
 */
const ModalHeader = props => {
  const {
    children,
    testId: userDefinedTestId
  } = props;
  const {
    testId: modalTestId
  } = useModal();
  const testId = userDefinedTestId || modalTestId && `${modalTestId}--header`;
  return jsx("div", {
    css: headerStyles,
    "data-testid": testId
  }, children);
};
export default ModalHeader;