/** @jsx jsx */
import { ReactNode } from 'react';
import { jsx } from '@emotion/react';
export interface ModalFooterProps {
    /**
     * Children of modal dialog footer.
     */
    children?: ReactNode;
    /**
     * A `testId` prop is provided for specified elements,
     * which is a unique string that appears as a data attribute `data-testid` in the rendered code,
     * serving as a hook for automated tests.
     */
    testId?: string;
}
/**
 * __Modal footer__
 *
 * A modal footer often contains a primary action and the ability to cancel and close the dialog, though can contain any React element.
 *
 * - [Examples](https://atlassian.design/components/modal-dialog/examples#modal-footer)
 * - [Code](https://atlassian.design/components/modal-dialog/code#modal-footer-props)
 * - [Usage](https://atlassian.design/components/modal-dialog/usage)
 */
declare const ModalFooter: (props: ModalFooterProps) => jsx.JSX.Element;
export default ModalFooter;
