import type { Appearance } from '../types';
export type WidthNames = 'small' | 'medium' | 'large' | 'x-large';
interface Width {
    values: string[];
    widths: {
        [index in WidthNames]: number;
    };
    defaultValue: string;
}
export declare const width: Width;
export declare const gutter = 60;
export declare const borderRadius: number;
export declare const verticalOffset: number;
export declare const padding: number;
export declare const titleIconMargin: number;
export declare const keylineHeight = 2;
export declare const keylineColor: "var(--ds-border)";
export declare const textColor: "var(--ds-text)";
export declare const iconColor: {
    [key in Appearance]: string;
};
export {};
