interface ModalStackOpts {
    /**
     * Fired when the modal dialog stack has changed.
     */
    onStackChange: (newStackIndex: number) => void;
}
/**
 * Returns the position of the calling modal dialog in the modal dialog stack.
 * Stack index of `0` is the highest position in the stack,
 * with every higher number being behind in the stack.
 */
export default function useModalStack({ onStackChange, }: ModalStackOpts): number;
export {};
