"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dialogWidth = exports.dialogHeight = void 0;
var _constants = require("./constants");
var dialogWidth = function dialogWidth(input) {
  if (!input) {
    return 'auto';
  }
  var isWidthName = _constants.width.values.indexOf(input.toString()) !== -1;
  var widthName = isWidthName && input;
  if (widthName) {
    return "".concat(_constants.width.widths[widthName], "px");
  }
  return typeof input === 'number' ? "".concat(input, "px") : input;
};
exports.dialogWidth = dialogWidth;
var dialogHeight = function dialogHeight(input) {
  if (!input) {
    return 'auto';
  }
  return typeof input === 'number' ? "".concat(input, "px") : input;
};
exports.dialogHeight = dialogHeight;