"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("@emotion/react");
var _hooks = require("./hooks");
var _constants = require("./internal/constants");
/** @jsx jsx */

var footerStyles = (0, _react.css)({
  display: 'flex',
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  padding: _constants.padding,
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  paddingTop: "".concat(_constants.padding - _constants.keylineHeight, "px"),
  position: 'relative',
  alignItems: 'center',
  justifyContent: 'flex-end',
  gap: "var(--ds-space-100, 8px)"
});
/**
 * __Modal footer__
 *
 * A modal footer often contains a primary action and the ability to cancel and close the dialog, though can contain any React element.
 *
 * - [Examples](https://atlassian.design/components/modal-dialog/examples#modal-footer)
 * - [Code](https://atlassian.design/components/modal-dialog/code#modal-footer-props)
 * - [Usage](https://atlassian.design/components/modal-dialog/usage)
 */
var ModalFooter = function ModalFooter(props) {
  var children = props.children,
    userDefinedTestId = props.testId;
  var _useModal = (0, _hooks.useModal)(),
    modalTestId = _useModal.testId;
  var testId = userDefinedTestId || modalTestId && "".concat(modalTestId, "--footer");
  return (0, _react.jsx)("div", {
    css: footerStyles,
    "data-testid": testId
  }, children);
};
var _default = ModalFooter;
exports.default = _default;