"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _hooks = require("./hooks");
var _constants = require("./internal/constants");
/** @jsx jsx */

var headerStyles = (0, _react2.css)({
  display: 'flex',
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  padding: _constants.padding,
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  paddingBottom: "".concat(_constants.padding - _constants.keylineHeight, "px"),
  position: 'relative',
  alignItems: 'center',
  justifyContent: 'space-between'
});
/**
 * __Modal header__
 *
 * A modal header contains the title of the modal and can contain other React elements such as a close button.
 *
 * - [Examples](https://atlassian.design/components/modal-dialog/examples#modal-header)
 * - [Code](https://atlassian.design/components/modal-dialog/code#modal-header-props)
 * - [Usage](https://atlassian.design/components/modal-dialog/usage)
 */
var ModalHeader = function ModalHeader(props) {
  var children = props.children,
    userDefinedTestId = props.testId;
  var _useModal = (0, _hooks.useModal)(),
    modalTestId = _useModal.testId;
  var testId = userDefinedTestId || modalTestId && "".concat(modalTestId, "--header");
  return (0, _react2.jsx)("div", {
    css: headerStyles,
    "data-testid": testId
  }, children);
};
var _default = ModalHeader;
exports.default = _default;