import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _typeof from "@babel/runtime/helpers/typeof";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _css;
/** @jsx jsx */
import { useMemo } from 'react';
import { css, jsx } from '@emotion/react';
import { useUID } from 'react-uid';
import mergeRefs from '@atlaskit/ds-lib/merge-refs';
import useAutoFocus from '@atlaskit/ds-lib/use-auto-focus';
import FocusRing from '@atlaskit/focus-ring';
import FadeIn from '@atlaskit/motion/fade-in';
import { media } from '@atlaskit/primitives';
import { N0, N30A, N60A } from '@atlaskit/theme/colors';
import { borderRadius, textColor } from '../constants';
import { ModalContext, ScrollContext } from '../context';
import useOnMotionFinish from '../hooks/use-on-motion-finish';
import { dialogHeight, dialogWidth } from '../utils';
import Positioner from './positioner';
var dialogStyles = css((_css = {
  display: 'flex',
  width: '100%',
  maxWidth: '100vw',
  height: '100%',
  minHeight: 0,
  maxHeight: '100vh',
  // Flex-grow set to 0 to prevent this element from filling its parent flexbox container
  flex: '0 1 auto',
  flexDirection: 'column',
  backgroundColor: "var(--ds-surface-overlay, ".concat(N0, ")"),
  color: textColor,
  pointerEvents: 'auto'
}, _defineProperty(_css, media.above.xs, {
  width: 'var(--modal-dialog-width)',
  maxWidth: 'inherit',
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  marginRight: 'inherit',
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  marginLeft: 'inherit',
  borderRadius: borderRadius,
  boxShadow: "var(--ds-shadow-overlay, ".concat("0 0 0 1px ".concat(N30A, ", 0 2px 1px ").concat(N30A, ", 0 0 20px -6px ").concat(N60A), ")")
}), _defineProperty(_css, '& > form:only-child', {
  display: 'inherit',
  maxHeight: 'inherit',
  flexDirection: 'inherit'
}), _css));
var viewportScrollStyles = css(_defineProperty({
  /**
   * This ensures that the element fills the viewport on mobile
   * while also allowing it to overflow if its height is larger than
   * the viewport.
   */
  minHeight: '100vh',
  maxHeight: 'none'
}, media.above.xs, {
  minHeight: 'var(--modal-dialog-height)'
}));
var bodyScrollStyles = css(_defineProperty({}, media.above.xs, {
  height: 'var(--modal-dialog-height)',
  maxHeight: 'inherit'
}));
var ModalDialog = function ModalDialog(props) {
  var _props$width = props.width,
    width = _props$width === void 0 ? 'medium' : _props$width,
    _props$shouldScrollIn = props.shouldScrollInViewport,
    shouldScrollInViewport = _props$shouldScrollIn === void 0 ? false : _props$shouldScrollIn,
    autoFocus = props.autoFocus,
    stackIndex = props.stackIndex,
    onClose = props.onClose,
    onCloseComplete = props.onCloseComplete,
    onOpenComplete = props.onOpenComplete,
    height = props.height,
    children = props.children,
    label = props.label,
    testId = props.testId;
  var id = useUID();
  var titleId = "modal-dialog-title-".concat(id);
  useAutoFocus(_typeof(autoFocus) === 'object' ? autoFocus : undefined,
  // When a user supplies  a ref to focus we enable this hook
  _typeof(autoFocus) === 'object');
  var _useOnMotionFinish = useOnMotionFinish({
      onOpenComplete: onOpenComplete,
      onCloseComplete: onCloseComplete
    }),
    _useOnMotionFinish2 = _slicedToArray(_useOnMotionFinish, 2),
    motionRef = _useOnMotionFinish2[0],
    onMotionFinish = _useOnMotionFinish2[1];
  var modalDialogContext = useMemo(function () {
    return {
      testId: testId,
      titleId: titleId,
      onClose: onClose
    };
  }, [testId, titleId, onClose]);
  return jsx(Positioner, {
    stackIndex: stackIndex,
    shouldScrollInViewport: shouldScrollInViewport,
    testId: testId
  }, jsx(ModalContext.Provider, {
    value: modalDialogContext
  }, jsx(ScrollContext.Provider, {
    value: shouldScrollInViewport
  }, jsx(FadeIn, {
    entranceDirection: "bottom",
    onFinish: onMotionFinish
  }, function (bottomFadeInProps) {
    return jsx(FocusRing, null, jsx("section", _extends({}, bottomFadeInProps, {
      "aria-label": label,
      ref: mergeRefs([bottomFadeInProps.ref, motionRef]),
      style: {
        '--modal-dialog-width': dialogWidth(width),
        '--modal-dialog-height': dialogHeight(height)
      },
      css: [dialogStyles, shouldScrollInViewport ? viewportScrollStyles : bodyScrollStyles],
      role: "dialog",
      "aria-labelledby": label ? undefined : titleId,
      "data-testid": testId,
      "data-modal-stack": stackIndex,
      tabIndex: -1,
      "aria-modal": true
    }), children));
  }))));
};

// eslint-disable-next-line @repo/internal/react/require-jsdoc
export default ModalDialog;