/// <reference types="react" />
import { ModalDialogProps, OnCloseHandler } from '../types';
export type ModalAttributes = {
    /**
     * Test id passed to the modal dialog.
     */
    testId?: ModalDialogProps['testId'];
    /**
     * Id referenced by the modal dialog's `aria-labelledby` attribute.
     * This id should be assigned to the modal title element.
     */
    titleId: string;
    /**
     * Callback function called when the modal dialog is requesting to be closed,
     * wrapped in modal dialog's analytic event context.
     */
    onClose?: OnCloseHandler;
};
export declare const ModalContext: import("react").Context<ModalAttributes | null>;
export declare const ScrollContext: import("react").Context<boolean | null>;
