/** @jsx jsx */
import React from 'react';
import { jsx } from '@emotion/react';
export interface ModalBodyProps {
    /**
     * Children of modal dialog footer.
     */
    children: React.ReactNode;
    /**
     * A `testId` prop is provided for specified elements,
     * which is a unique string that appears as a data attribute `data-testid` in the rendered code,
     * serving as a hook for automated tests.
     */
    testId?: string;
}
/**
 * __Modal body__
 *
 * A modal body is used to display the main content of a modal.
 *
 * - [Examples](https://atlassian.design/components/modal-dialog/examples)
 * - [Code](https://atlassian.design/components/modal-dialog/code#modal-body-props)
 * - [Usage](https://atlassian.design/components/modal-dialog/usage)
 */
declare const ModalBody: (props: ModalBodyProps) => jsx.JSX.Element;
export default ModalBody;
