/** @jsx jsx */
import React from 'react';
interface ScrollContainerProps {
    /**
     * Children of the body within modal dialog.
     */
    children: React.ReactNode;
    /**
     * A `testId` prop is provided for specified elements,
     * which is a unique string that appears as a data attribute `data-testid` in the rendered code,
     * serving as a hook for automated tests.
     */
    testId?: string;
}
/**
 * A container that shows top and bottom keylines when the
 * content overflows into the scrollable element.
 */
declare const ScrollContainer: React.ForwardRefExoticComponent<ScrollContainerProps & React.RefAttributes<HTMLElement | null>>;
export default ScrollContainer;
