/** @jsx jsx */
import { ReactNode } from 'react';
import { jsx } from '@emotion/react';
import { Appearance } from './types';
export interface ModalTitleProps {
    /**
     * Appearance of the modal that changes the color of the primary action and adds an icon to the title.
     */
    appearance?: Appearance;
    /**
     * Children of modal dialog header.
     */
    children?: ReactNode;
    /**
     * When `true` will allow the title to span multiple lines.
     * Defaults to `true`.
     */
    isMultiline?: boolean;
    /**
     * A `testId` prop is provided for specified elements,
     * which is a unique string that appears as a data attribute `data-testid` in the rendered code,
     * serving as a hook for automated tests.
     */
    testId?: string;
}
/**
 * __Modal title__
 *
 * A modal title is used to display a title within a modal.
 *
 * - [Examples](https://atlassian.design/components/modal-dialog/examples)
 * - [Code](https://atlassian.design/components/modal-dialog/code)
 * - [Usage](https://atlassian.design/components/modal-dialog/usage)
 */
declare const ModalTitle: (props: ModalTitleProps) => jsx.JSX.Element;
export default ModalTitle;
