/** @jsx jsx */
import { jsx } from '@emotion/react';
import type { ModalDialogProps } from './types';
export type { ModalDialogProps };
/**
 * __Modal wrapper__
 *
 * A modal wrapper displays content that requires user interaction, in a layer above the page.
 * This component is primary container for other modal components.
 *
 * - [Examples](https://atlassian.design/components/modal-dialog/examples)
 * - [Code](https://atlassian.design/components/modal-dialog/code)
 * - [Usage](https://atlassian.design/components/modal-dialog/usage)
 */
declare const ModalWrapper: (props: ModalDialogProps) => jsx.JSX.Element;
export default ModalWrapper;
